/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.annotations.pojo.Action;
import de.mhus.lib.annotations.pojo.Embedded;
import de.mhus.lib.annotations.pojo.Hidden;
import de.mhus.lib.core.pojo.PojoAction;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoFilter;
import de.mhus.lib.core.pojo.PojoModelImpl;

public class DefaultFilter
implements PojoFilter {
    private boolean removeHidden;
    private boolean removeWriteOnly;
    private boolean removeReadOnly;
    private boolean removeEmbedded;
    private boolean removeNoActions;

    public DefaultFilter() {
        this(true, false, true, false, true);
    }

    public DefaultFilter(boolean removeHidden, boolean removeEmbedded, boolean removeWriteOnly, boolean removeReadOnly, boolean removeNoActions) {
        this.removeHidden = removeHidden;
        this.removeEmbedded = removeEmbedded;
        this.removeWriteOnly = removeWriteOnly;
        this.removeReadOnly = removeReadOnly;
        this.removeNoActions = removeNoActions;
    }

    @Override
    public void filter(PojoModelImpl model) {
        String name;
        String[] stringArray = model.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            PojoAttribute attr = model.getAttribute(name);
            if (this.removeHidden && attr.getAnnotation(Hidden.class) != null) {
                model.removeAttribute(name);
            } else if (this.removeEmbedded && attr.getAnnotation(Embedded.class) != null) {
                model.removeAttribute(name);
            } else if (this.removeWriteOnly && !attr.canRead()) {
                model.removeAttribute(name);
            } else if (this.removeReadOnly && !attr.canWrite()) {
                model.removeAttribute(name);
            }
            ++n2;
        }
        stringArray = model.getActionNames();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            PojoAction action = model.getAction(name);
            if (this.removeNoActions && action.getAnnotation(Action.class) == null) {
                model.removeAction(name);
            }
            ++n2;
        }
    }
}

