/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.annotations.generic.Public;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.pojo.FunctionAction;
import de.mhus.lib.core.pojo.FunctionAttribute;
import de.mhus.lib.core.pojo.MethodAnalyser;
import de.mhus.lib.core.pojo.PojoModelImpl;
import de.mhus.lib.core.pojo.PojoParser;
import de.mhus.lib.core.pojo.PojoStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Set;

public class ActionsOnlyStrategy
extends MObject
implements PojoStrategy {
    private boolean toLower = true;
    private Class<? extends Annotation>[] annotationMarker;
    private boolean allowPublic = true;

    public ActionsOnlyStrategy() {
        this(true, new Class[0]);
    }

    @SafeVarargs
    public ActionsOnlyStrategy(boolean toLower, Class<? extends Annotation> ... annotationMarker) {
        this.toLower = toLower;
        this.annotationMarker = annotationMarker;
    }

    @Override
    public void parse(PojoParser parser, Class<?> clazz, PojoModelImpl model) {
        this.parse("", null, parser, clazz, model, 0);
    }

    protected void parse(String prefix, FunctionAttribute<Object> parent, PojoParser parser, Class<?> clazz, PojoModelImpl model, int level) {
        if (level > 10) {
            return;
        }
        for (Method m : this.getMethods(clazz)) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            Public desc = m.getAnnotation(Public.class);
            if (!this.allowPublic) {
                desc = null;
            }
            try {
                String mName = m.getName();
                if (desc != null && desc.name().length() > 0) {
                    mName = desc.name();
                }
                String s = this.toLower ? mName.toLowerCase() : mName;
                String name = String.valueOf(prefix) + s;
                if (!this.isMarker(clazz, m)) continue;
                FunctionAction action = new FunctionAction(clazz, m, name, parent);
                model.addAction(action);
            }
            catch (Exception e) {
                this.log().d(e);
            }
        }
    }

    private boolean isMarker(Class<?> clazz, Method m) {
        if (this.annotationMarker == null || this.annotationMarker.length == 0) {
            return true;
        }
        if (m != null) {
            Class<? extends Annotation>[] classArray = this.annotationMarker;
            int n = this.annotationMarker.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Annotation> a = classArray[n2];
                if (m.isAnnotationPresent(a)) {
                    return true;
                }
                ++n2;
            }
            Set<Method> res = MethodAnalyser.getMethodsForMethod(clazz, m.getName());
            for (Method m2 : res) {
                Class<? extends Annotation>[] classArray2 = this.annotationMarker;
                int n3 = this.annotationMarker.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<? extends Annotation> a = classArray2[n4];
                    if (m2.isAnnotationPresent(a)) {
                        return true;
                    }
                    ++n4;
                }
            }
        }
        return false;
    }

    protected LinkedList<Method> getMethods(Class<?> clazz) {
        LinkedList<Method> out = new LinkedList<Method>();
        do {
            Method[] methodArray = clazz.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                out.add(m);
                ++n2;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return out;
    }

    @Override
    public void parseObject(PojoParser parser, Object pojo, PojoModelImpl model) {
        Class<?> clazz = pojo.getClass();
        this.parse(parser, clazz, model);
    }

    public boolean isAllowPublic() {
        return this.allowPublic;
    }

    public ActionsOnlyStrategy setAllowPublic(boolean allowPublic) {
        this.allowPublic = allowPublic;
        return this;
    }
}

