/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.matcher;

import de.mhus.lib.core.matcher.Context;
import de.mhus.lib.core.matcher.ModelAnd;
import de.mhus.lib.core.matcher.ModelComposit;
import de.mhus.lib.core.matcher.ModelFs;
import de.mhus.lib.core.matcher.ModelOr;
import de.mhus.lib.core.matcher.ModelPattern;
import de.mhus.lib.core.matcher.ModelRegex;
import de.mhus.lib.core.matcher.ModelSql;
import de.mhus.lib.core.parser.StringTokenizerParser;
import de.mhus.lib.core.parser.TechnicalStringParser;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.SyntaxError;

public class Matcher {
    ModelComposit root = null;

    public Matcher(String condition) throws MException {
        TechnicalStringParser tokenizer = new TechnicalStringParser(condition);
        tokenizer.setBreakableCharacters("()!");
        this.parse(tokenizer);
    }

    public boolean matches(String str) {
        if (str == null || this.root == null) {
            return false;
        }
        return this.root.m(str);
    }

    protected void parse(StringTokenizerParser condition) throws MException {
        this.root = null;
        ModelPattern pattern = null;
        Context context = new Context();
        for (String part : condition) {
            boolean isPattern;
            block51: {
                String lp;
                block50: {
                    if (part == null) continue;
                    lp = part.toLowerCase();
                    isPattern = false;
                    if (!condition.isTokenEncapsulated()) break block50;
                    isPattern = true;
                    break block51;
                }
                switch (lp) {
                    case "!": 
                    case "not": {
                        context.not = true;
                        break;
                    }
                    case "&&": 
                    case "and": {
                        if (context.not) {
                            throw new SyntaxError(new Object[]{"not before operator"});
                        }
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type before operator"});
                        }
                        if (context.current != null && context.current instanceof ModelAnd) break;
                        Object next = new ModelAnd();
                        context.append((ModelComposit)next);
                        break;
                    }
                    case "or": 
                    case "||": {
                        if (context.not) {
                            throw new SyntaxError(new Object[]{"not before operator"});
                        }
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type before operator"});
                        }
                        if (context.current != null && context.current instanceof ModelAnd) break;
                        Object next = new ModelOr();
                        context.append((ModelComposit)next);
                        break;
                    }
                    case "(": {
                        Object next = new Context();
                        ((Context)next).parentContext = context;
                        context = next;
                        break;
                    }
                    case ")": {
                        if (context.parent == null) {
                            throw new SyntaxError(new Object[]{"can't close bracket"});
                        }
                        Context last = context;
                        context = context.parentContext;
                        ModelComposit next = last.findRoot();
                        if (last.current == null && last.first != null) {
                            ModelAnd and = new ModelAnd();
                            and.setNot(last.not);
                            last.current = and;
                        } else {
                            next.setNot(context.not);
                        }
                        context.append(next);
                        break;
                    }
                    case "fs": {
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type after pattern"});
                        }
                        pattern = new ModelFs();
                        break;
                    }
                    case "sql": {
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type after pattern"});
                        }
                        pattern = new ModelSql();
                        break;
                    }
                    case "regex": {
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type after pattern"});
                        }
                        pattern = new ModelRegex();
                        break;
                    }
                    default: {
                        isPattern = true;
                    }
                }
            }
            if (!isPattern) continue;
            if (context.current == null && context.first != null) {
                throw new SyntaxError(new Object[]{"pattern after pattern without operation"});
            }
            if (pattern == null) {
                pattern = new ModelRegex();
            }
            pattern.setPattern(part);
            pattern.setNot(context.not);
            if (context.current == null) {
                context.first = pattern;
            } else {
                context.current.add(pattern);
            }
            context.not = false;
            pattern = null;
        }
        if (context.parentContext != null) {
            throw new SyntaxError(new Object[]{"bracked not closed"});
        }
        this.root = context.findRoot();
    }

    public String toString() {
        return this.root == null ? "[null]" : this.root.toString();
    }
}

