/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.jmx;

import de.mhus.lib.core.jmx.JmxObject;
import de.mhus.lib.core.jmx.MRemoteManager;
import java.util.HashSet;

public class JmxPackage
extends JmxObject {
    private HashSet<JmxObject> registry = new HashSet();
    private MRemoteManager remoteManager;

    public void open(MRemoteManager remoteManager) {
        this.remoteManager = remoteManager;
        for (JmxObject bo : this.registry) {
            try {
                remoteManager.register(bo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        for (JmxObject bo : this.registry) {
            try {
                this.remoteManager.unregister(bo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.remoteManager = null;
    }

    public void register(JmxObject object) throws Exception {
        object.setJmxPackage(this.getJmxPackage());
        if (this.remoteManager != null) {
            this.remoteManager.register(object);
        }
        this.registry.add(object);
    }

    public void unregister(JmxObject object) throws Exception {
        if (this.remoteManager != null) {
            this.remoteManager.unregister(object);
        }
        this.registry.remove(object);
    }
}

