/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.jmx;

import de.mhus.lib.annotations.jmx.JmxManaged;
import de.mhus.lib.core.jmx.JmxDescriptionDynamic;
import de.mhus.lib.core.jmx.JmxDescriptionMBean;
import de.mhus.lib.core.jmx.JmxDescritionAnnotations;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public abstract class JmxDescription {
    public static JmxDescription create(Object in) throws Exception {
        if (in instanceof DynamicMBean) {
            return new JmxDescriptionDynamic(in);
        }
        Class<?> current = in.getClass();
        do {
            if (!current.isAnnotationPresent(JmxManaged.class)) continue;
            return new JmxDescritionAnnotations(in);
        } while ((current = current.getSuperclass()) != null);
        return new JmxDescriptionMBean(in);
    }

    public abstract Object getAttribute(Object var1, String var2) throws AttributeNotFoundException, MBeanException, ReflectionException;

    public abstract void setAttribute(Object var1, Attribute var2) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException;

    public AttributeList getAttributes(Object o, String[] attributes) {
        AttributeList list = new AttributeList();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                Object value = this.getAttribute(o, name);
                if (value != null) {
                    list.add(new Attribute(name, value));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return list;
    }

    public AttributeList setAttributes(Object o, AttributeList attributes) {
        Attribute[] attrs = attributes.toArray(new Attribute[0]);
        AttributeList retlist = new AttributeList();
        Attribute[] attributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            String name = attr.getName();
            Object value = attr.getValue();
            try {
                this.setAttribute(o, attr);
                retlist.add(new Attribute(name, value));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return retlist;
    }

    public abstract Object invoke(Object var1, String var2, Object[] var3, String[] var4) throws MBeanException, ReflectionException;

    public abstract MBeanInfo getMBeanInfo();
}

