/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import java.io.IOException;
import java.io.InputStream;

public class TextReader {
    private InputStream myInput;
    private int myNextChar;
    private boolean myUndefinedState;
    private boolean mySignificantEol;

    public TextReader(InputStream input) {
        this.myInput = input;
        this.myUndefinedState = true;
    }

    private int read() {
        try {
            int result = this.myInput.read();
            if (result == 13) {
                result = this.myInput.read();
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void checkState() {
        if (this.myUndefinedState) {
            this.myUndefinedState = false;
            this.myNextChar = this.read();
        }
    }

    public char readChar() {
        this.checkState();
        if (this.myNextChar == -1) {
            throw new RuntimeException("Attempt to read past end of file");
        }
        char result = (char)this.myNextChar;
        if (this.myNextChar == 10) {
            this.myUndefinedState = true;
        } else {
            this.myNextChar = this.read();
            if (this.myNextChar == -1) {
                this.myNextChar = 10;
            }
        }
        return result;
    }

    public char peek() {
        this.checkState();
        if (this.myNextChar == -1) {
            throw new RuntimeException("Attempt to peek past end of file");
        }
        return (char)this.myNextChar;
    }

    public boolean ready() {
        this.checkState();
        return this.myNextChar != -1;
    }

    public String readLine() {
        char next;
        this.checkState();
        String result = "";
        while ((next = this.readChar()) != '\n') {
            result = String.valueOf(result) + next;
        }
        return result;
    }

    public void eolIsSignificant(boolean flag) {
        this.mySignificantEol = flag;
    }

    public void skipWhite(boolean skipEoln) {
        this.checkState();
        while (this.ready() && Character.isWhitespace(this.peek()) && (skipEoln || this.peek() != '\n')) {
            this.readChar();
        }
    }

    public String readWord() {
        String result = "";
        this.skipWhite(true);
        while (this.ready() && !Character.isWhitespace(this.peek())) {
            result = String.valueOf(result) + this.readChar();
        }
        this.skipWhite(false);
        if (this.ready() && this.peek() == '\n' && !this.mySignificantEol) {
            this.readChar();
        }
        return result;
    }

    public int readInt() {
        return Integer.parseInt(this.readWord());
    }

    public double readDouble() {
        return Double.parseDouble(this.readWord());
    }
}

