/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MApi;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class MObjectInputStream
extends ObjectInputStream {
    private ClassLoader cl = null;
    private MActivator act = null;

    public MObjectInputStream() throws IOException, SecurityException {
    }

    public MObjectInputStream(InputStream in, MActivator act) throws IOException {
        super(in);
        this.setActivator(act);
    }

    public MObjectInputStream(InputStream in, ClassLoader cl) throws IOException {
        super(in);
        this.setClassLoader(cl);
    }

    public MObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    public void setActivator(MActivator activator) {
        this.act = activator;
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        if (this.act == null && this.cl == null) {
            this.act = MApi.get().base().lookup(MActivator.class);
        }
        try {
            if (this.act != null) {
                return this.act.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            return Class.forName(name, true, this.cl);
        }
        catch (ClassNotFoundException ex) {
            return super.resolveClass(desc);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader latestLoader = this.cl;
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            Class<?> cl = Class.forName(interfaces[i], false, latestLoader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i] = cl;
            ++i;
        }
        try {
            return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : latestLoader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

