/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.definition;

import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.definition.DefAttribute;
import de.mhus.lib.core.definition.IDefDefinition;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.errors.MException;
import java.util.LinkedList;
import java.util.Properties;

public class DefComponent
extends HashConfig
implements IDefDefinition {
    private static final long serialVersionUID = 1L;
    private String tag;
    private LinkedList<IDefDefinition> definitions = new LinkedList();

    public DefComponent(String tag, IDefDefinition ... definitions) {
        super(tag, null);
        this.tag = tag;
        this.addDefinition(definitions);
    }

    public DefComponent addAttribute(String name, Object value) {
        return this.addDefinition(new DefAttribute(name, value));
    }

    public DefComponent addDefinition(IDefDefinition ... def) {
        if (def == null) {
            return this;
        }
        IDefDefinition[] iDefDefinitionArray = def;
        int n = def.length;
        int n2 = 0;
        while (n2 < n) {
            IDefDefinition d = iDefDefinitionArray[n2];
            if (d != null) {
                this.definitions.add(d);
            }
            ++n2;
        }
        return this;
    }

    public LinkedList<IDefDefinition> definitions() {
        return this.definitions;
    }

    @Override
    public void inject(DefComponent parent) throws MException {
        if (parent != null) {
            parent.setConfig(this.tag, this);
        }
        for (IDefDefinition d : this.definitions) {
            d.inject(this);
        }
    }

    public void fillNls(Properties p) throws MException {
        String nls = this.getString("nls", null);
        if (nls == null) {
            nls = this.getString("name", null);
        }
        if (nls != null && this.isProperty("title")) {
            p.setProperty(String.valueOf(nls) + "_title", this.getString("title", null));
        }
        if (nls != null && this.isProperty("description")) {
            p.setProperty(String.valueOf(nls) + "_description", this.getString("description", null));
        }
        this.fill(this, p);
    }

    private void fill(HashConfig config, Properties p) throws MException {
        for (ResourceNode c : config.getNodes()) {
            if (c instanceof DefComponent) {
                ((DefComponent)c).fillNls(p);
                continue;
            }
            this.fill((HashConfig)c, p);
        }
    }
}

