/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt.pem;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.MValidator;
import de.mhus.lib.core.crypt.pem.PemBlock;
import de.mhus.lib.core.crypt.pem.PemBlockModel;
import de.mhus.lib.core.crypt.pem.PemKey;
import de.mhus.lib.core.crypt.pem.PemPriv;
import de.mhus.lib.core.crypt.pem.PemPub;
import de.mhus.lib.core.parser.ParseException;
import de.mhus.lib.core.vault.MVault;
import de.mhus.lib.core.vault.MVaultUtil;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.errors.NotSupportedException;
import java.io.IOException;
import java.util.UUID;

public class PemUtil {
    public static PemPriv signPrivFromString(String str) throws Exception, NotSupportedException, IOException {
        if (MValidator.isUUID(str)) {
            MVault vault = MVaultUtil.loadDefault();
            VaultEntry entry = vault.getEntry(UUID.fromString(str));
            PemPriv key = entry.adaptTo(PemPriv.class);
            return key;
        }
        if (PemUtil.isPemBlock(str)) {
            PemBlockModel block = new PemBlockModel().parse(str);
            return new PemKey(block);
        }
        String name = MString.beforeIndex(str, ':');
        String key = MString.afterIndex(str, ':');
        return (PemPriv)((PemBlockModel)new PemKey("SIGNATURE").set("Method", name)).setBlock(key);
    }

    public static PemPub signPubFromString(String str) throws NotSupportedException, IOException, ParseException {
        if (MValidator.isUUID(str)) {
            MVault vault = MVaultUtil.loadDefault();
            VaultEntry entry = vault.getEntry(UUID.fromString(str));
            PemPub key = entry.adaptTo(PemPub.class);
            return key;
        }
        if (PemUtil.isPemBlock(str)) {
            PemBlockModel block = new PemBlockModel().parse(str);
            return new PemKey(block);
        }
        String name = MString.beforeIndex(str, ':');
        String key = MString.afterIndex(str, ':');
        return (PemPub)((PemBlockModel)new PemKey("SIGNATURE").set("Method", name)).setBlock(key);
    }

    public static PemPriv cipherPrivFromString(String str) throws ParseException, NotSupportedException, IOException {
        if (MValidator.isUUID(str)) {
            MVault vault = MVaultUtil.loadDefault();
            VaultEntry entry = vault.getEntry(UUID.fromString(str));
            PemPriv key = entry.adaptTo(PemPriv.class);
            return key;
        }
        if (PemUtil.isPemBlock(str)) {
            PemBlockModel block = new PemBlockModel().parse(str);
            return new PemKey(block);
        }
        String name = MString.beforeIndex(str, ':').toUpperCase().trim();
        String key = MString.afterIndex(str, ':').trim();
        return (PemPriv)((PemBlockModel)new PemKey("CIPHER").set("Method", name)).setBlock(key);
    }

    public static boolean isPemBlock(String text) {
        if (text == null) {
            return false;
        }
        int p1 = text.indexOf("-----START");
        int p2 = text.indexOf("-----END");
        return text.indexOf("\n") >= 0 && p1 >= 0 && p2 > 0 && p2 > p1;
    }

    public static PemPub cipherPubFromString(String str) throws ParseException, NotSupportedException, IOException {
        if (MValidator.isUUID(str)) {
            MVault vault = MVaultUtil.loadDefault();
            VaultEntry entry = vault.getEntry(UUID.fromString(str));
            PemPub key = entry.adaptTo(PemPub.class);
            return key;
        }
        if (PemUtil.isPemBlock(str)) {
            PemBlockModel block = new PemBlockModel().parse(str);
            return new PemKey(block);
        }
        String name = MString.beforeIndex(str, ':');
        String key = MString.afterIndex(str, ':');
        return (PemPub)((PemBlockModel)new PemKey("CIPHER").set("Method", name)).setBlock(key);
    }

    public static String toLine(PemBlock key) {
        return String.valueOf(key.getString("Method", "?")) + ":" + key.getBlock();
    }

    public static boolean isCipher(PemBlock block) {
        return "CIPHER".equals(block.getName());
    }

    public static boolean isSign(PemBlock block) {
        return "SIGNATURE".equals(block.getName());
    }

    public static boolean isHash(PemBlock block) {
        return "HASH".equals(block.getName());
    }

    public static boolean isPrivKey(PemBlock block) {
        return "PRIVATE KEY".equals(block.getName());
    }

    public static boolean isPubKey(PemBlock block) {
        return "PUBLIC KEY".equals(block.getName());
    }

    public static boolean isContent(PemBlock block) {
        return "CONTENT".equals(block.getName());
    }

    public static PemKey toKey(String key) throws ParseException {
        return new PemKey(new PemBlockModel().parse(key));
    }
}

