/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt.pem;

import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.crypt.pem.PemBlock;
import de.mhus.lib.core.parser.ParseException;
import java.util.Base64;
import java.util.Map;

public class PemBlockModel
extends MProperties
implements PemBlock {
    private String name;
    protected String block;
    private String rest;
    private static final int BLOCK_WIDTH = 50;

    public PemBlockModel() {
    }

    public PemBlockModel(String name) {
        this.setName(name);
    }

    public PemBlockModel(String name, String block) {
        this.setName(name);
        this.setBlock(block);
    }

    public PemBlockModel(String name, byte[] block) {
        this.setName(name);
        this.setBlock(block);
    }

    public PemBlockModel(PemBlock clone) {
        this.setName(clone.getName());
        this.block = clone.getBlock();
        for (Map.Entry<String, Object> item : clone.entrySet()) {
            this.put(item.getKey(), item.getValue());
        }
    }

    public PemBlockModel parse(String block) throws ParseException {
        int p = block.indexOf("-----START ");
        if (p < 0) {
            throw new ParseException("start of block not found");
        }
        if ((p = (block = block.substring(p + 11)).indexOf("-----")) < 0) {
            throw new ParseException("end of header not found");
        }
        String n = block.substring(0, p);
        if (n.contains("\n") || n.contains("\r")) {
            throw new ParseException("name contains line break", n);
        }
        this.setName(n);
        block = block.substring(p + 5);
        String endMark = "-----END " + this.getName() + "-----";
        p = block.indexOf(endMark);
        if (p < 0) {
            throw new ParseException("end of block not found", this.getName());
        }
        this.rest = block.substring(p + endMark.length()).trim();
        block = block.substring(0, p).trim();
        boolean params = true;
        String blockOrg = "";
        do {
            String line = block;
            p = block.indexOf(10);
            if (p >= 0) {
                line = block.substring(0, p);
                block = block.substring(p + 1);
            }
            if (params) {
                if ((line = line.trim()).length() == 0) {
                    params = false;
                    continue;
                }
                int pp = line.indexOf(58);
                if (pp < 0) {
                    params = false;
                    blockOrg = line;
                    continue;
                }
                String key = line.substring(0, pp).trim();
                String value = line.substring(pp + 1).trim();
                this.setString(key, value);
                continue;
            }
            blockOrg = String.valueOf(blockOrg) + line;
        } while (p >= 0);
        this.block = MString.decodeUnicode(blockOrg);
        return this;
    }

    public String getRest() {
        return this.rest;
    }

    protected void setName(String name) {
        this.name = name.toUpperCase();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBlock() {
        return this.block;
    }

    public <T extends PemBlockModel> T setBlock(String block) {
        this.block = block;
        return (T)this;
    }

    public <T extends PemBlockModel> T set(String key, Object value) {
        this.put(key, value);
        return (T)this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----START ").append(this.getName()).append("-----\n");
        for (Map.Entry<String, Object> item : this.entrySet()) {
            sb.append(item.getKey()).append(": ").append(item.getValue()).append('\n');
        }
        sb.append('\n');
        sb.append(this.getEncodedBlock());
        sb.append("\n\n");
        sb.append("-----END ").append(this.getName()).append("-----\n");
        return sb.toString();
    }

    public String getEncodedBlock() {
        String b = MString.encodeUnicode(this.block, true);
        StringBuilder c = new StringBuilder();
        while (b.length() > 50) {
            c.append(b.substring(0, 50)).append('\n');
            b = b.substring(50);
        }
        c.append(b);
        return c.toString();
    }

    public <T extends PemBlockModel> T setBlock(byte[] bytes) {
        this.setBlock(Base64.getEncoder().encodeToString(bytes));
        return (T)this;
    }

    @Override
    public byte[] getBytesBlock() {
        return Base64.getDecoder().decode(this.getBlock());
    }
}

