/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MMath;
import java.io.IOException;
import java.io.InputStream;

public class SaltInputStream
extends InputStream {
    private InputStream previous;
    private boolean hasRandomBlocks;
    private int cnt;
    private byte salt;

    public SaltInputStream(InputStream previous, boolean hasRandomBlocks) {
        this.previous = previous;
        this.hasRandomBlocks = hasRandomBlocks;
        this.cnt = 0;
    }

    @Override
    public int read() throws IOException {
        int out;
        --this.cnt;
        if (this.cnt <= 0) {
            int s;
            if (this.hasRandomBlocks) {
                int c = this.previous.read();
                if (c < 0) {
                    return c;
                }
                int i = 0;
                while (i < c) {
                    int r = this.previous.read();
                    if (r < 0) {
                        return r;
                    }
                    ++i;
                }
            }
            if ((s = this.previous.read()) < 0) {
                return s;
            }
            this.salt = (byte)s;
            this.cnt = this.previous.read();
            if (this.cnt < 0) {
                return this.cnt;
            }
        }
        if ((out = this.previous.read()) < 0) {
            return out;
        }
        out = MMath.unsignetByteToInt(MMath.subRotate((byte)out, this.salt));
        return out;
    }

    @Override
    public void close() throws IOException {
        this.previous.close();
    }
}

