/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.crypt.AsyncKey;
import de.mhus.lib.core.crypt.MCrypt;
import de.mhus.lib.core.crypt.MRandom;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.LinkedList;

public class CipherEncodeAsync
extends OutputStream {
    private AsyncKey key;
    private byte[] buffer;
    private int bufferPos;
    private MRandom random;
    private int bufferMin;
    private int bufferMax;
    private LinkedList<BigInteger> list = new LinkedList();

    public CipherEncodeAsync(AsyncKey key, MRandom random) {
        this.key = key;
        this.random = random;
        int cnt = Math.min(key.getMaxLoad() - 1, 254);
        this.buffer = new byte[cnt];
        this.bufferPos = 0;
        this.bufferMin = this.buffer.length / 3;
        this.bufferMax = this.buffer.length * 2 / 3;
    }

    @Override
    public void write(int b) throws IOException {
        ++this.bufferPos;
        this.buffer[this.bufferPos] = (byte)b;
        if (this.bufferPos < this.bufferMin) {
            return;
        }
        if (this.bufferPos > this.bufferMax || this.random.getDouble() > 0.7) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.bufferPos == 0) {
            return;
        }
        this.buffer[0] = (byte)this.bufferPos;
        ++this.bufferPos;
        int rndCnt = Math.min(Math.abs(this.random.getInt()) + 1, this.buffer.length - this.bufferPos);
        int i = 0;
        while (i < rndCnt) {
            this.buffer[this.bufferPos + i] = this.random.getByte();
            ++i;
        }
        byte[] bigEndian = new byte[this.bufferPos + rndCnt];
        int i2 = 0;
        while (i2 < bigEndian.length) {
            bigEndian[i2] = this.buffer[bigEndian.length - i2 - 1];
            ++i2;
        }
        BigInteger org = new BigInteger(1, bigEndian);
        BigInteger enc = MCrypt.encode(this.key, org);
        this.list.add(enc);
        this.bufferPos = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    public BigInteger[] toBigInteger() {
        return this.list.toArray(new BigInteger[this.list.size()]);
    }

    public void clear() {
        this.list.clear();
        this.bufferPos = 0;
    }
}

