/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.io.PipedStream;
import de.mhus.lib.core.io.TextReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;

public class VirtualConsole
extends Console {
    protected int height = DEFAULT_HEIGHT;
    protected int width = DEFAULT_WIDTH;
    private Props[][] buffer = null;
    private int x;
    private int y;
    private Console.COLOR foreground;
    private Console.COLOR background;
    private boolean blink;
    private boolean bold;
    protected boolean echo;
    private PipedStream piped = new PipedStream();
    private TextReader reader = new TextReader(this.piped.getIn());
    private VirtualInStream writerStream = new VirtualInStream();
    private PrintStream writer = new PrintStream(this.writerStream);
    private boolean quiet;

    public VirtualConsole() throws IOException {
        super(new PrintStream(new ByteArrayOutputStream()), true, "ASCII");
        this.out = new VirtualOutStream();
        this.reset();
    }

    public void reset() {
        this.blink = false;
        this.bold = false;
        this.background = Console.COLOR.BLACK;
        this.foreground = Console.COLOR.WHITE;
        this.x = 0;
        this.y = 0;
        this.buffer = new Props[this.height][this.width];
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                this.buffer[y][x] = new Props();
                ++x;
            }
            ++y;
        }
    }

    @Override
    public String readLine(LinkedList<String> history) {
        return this.reader.readLine();
    }

    @Override
    public String readPassword() {
        this.quiet = true;
        try {
            String string = this.readLine();
            return string;
        }
        finally {
            this.quiet = false;
        }
    }

    @Override
    public boolean isSupportSize() {
        return true;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void resize(int width, int height) {
        int x;
        Props[][] newBuffer = new Props[height][width];
        int y = 0;
        while (y < height) {
            x = 0;
            while (x < width) {
                newBuffer[y][x] = new Props();
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.height) {
            x = 0;
            while (x < this.width) {
                if (y < height && x < width) {
                    newBuffer[y][x] = this.buffer[y][x];
                }
                ++x;
            }
            ++y;
        }
        this.buffer = newBuffer;
        this.width = width;
        this.height = height;
        this.x %= width;
        this.y = Math.min(this.y, height - 1);
    }

    @Override
    public boolean isSupportCursor() {
        return true;
    }

    @Override
    public void setCursor(int x, int y) {
        this.x = x % this.width;
        this.y = Math.min(y, this.height - 1);
    }

    @Override
    public int getCursorX() {
        return this.x;
    }

    @Override
    public int getCursorY() {
        return this.y;
    }

    @Override
    public boolean isSupportColor() {
        return true;
    }

    @Override
    public void setColor(Console.COLOR foreground, Console.COLOR background) {
        this.foreground = foreground;
        this.background = background;
    }

    @Override
    public Console.COLOR getForegroundColor() {
        return this.foreground;
    }

    @Override
    public Console.COLOR getBackgroundColor() {
        return this.background;
    }

    @Override
    public boolean isSupportBlink() {
        return true;
    }

    @Override
    public void setBlink(boolean blink) {
        this.blink = blink;
    }

    @Override
    public boolean isBlink() {
        return this.blink;
    }

    @Override
    public boolean isSupportBold() {
        return true;
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    public PrintStream getInputWriter() {
        return this.writer;
    }

    public String getMonoDisplayAsString() {
        StringBuilder out = new StringBuilder();
        out.append("+");
        int x = 0;
        while (x < this.width) {
            out.append("-");
            ++x;
        }
        out.append("+\n");
        int y = 0;
        while (y < this.height) {
            out.append("|");
            int x2 = 0;
            while (x2 < this.width) {
                out.append(this.buffer[y][x2].c);
                ++x2;
            }
            out.append("|\n");
            ++y;
        }
        out.append("+");
        x = 0;
        while (x < this.width) {
            out.append("-");
            ++x;
        }
        out.append("+");
        return out.toString();
    }

    protected void fillInputBuffer(char c) throws IOException {
        if (!this.quiet) {
            this.writeChar(c);
        }
        this.piped.getOut().write(c);
    }

    protected void writeChar(char c) {
        if (this.echo) {
            System.out.print(c);
        }
        this.x %= this.width;
        this.y = Math.min(this.y, this.height - 1);
        if (c == '\r') {
            this.x = 0;
        } else if (c == '\t') {
            while (this.x % 7 == 0) {
                this.writeChar(' ');
            }
        } else if (c == '\n') {
            this.x = 0;
            if (this.y >= this.height - 1) {
                this.scrollLineUp();
            } else {
                ++this.y;
            }
        } else {
            Props p = this.buffer[this.y][this.x];
            if (p == null) {
                this.buffer[this.y][this.x] = p = new Props();
            }
            p.set(c);
            if (this.x >= this.width - 1) {
                if (this.y >= this.height - 1) {
                    this.scrollLineUp();
                } else {
                    ++this.y;
                }
                this.x = 0;
            } else {
                ++this.x;
            }
        }
        this.x %= this.width;
        this.y = Math.min(this.y, this.height - 1);
    }

    private void scrollLineUp() {
        int i = 0;
        while (i < this.height - 1) {
            this.buffer[i] = this.buffer[i + 1];
            ++i;
        }
        this.buffer[this.height - 1] = new Props[this.width];
        i = 0;
        while (i < this.width) {
            this.buffer[this.height - 1][i] = new Props();
            ++i;
        }
    }

    @Override
    public void cleanup() {
        this.bold = false;
        this.blink = false;
        this.foreground = Console.COLOR.WHITE;
        this.background = Console.COLOR.BLACK;
    }

    protected class Props {
        Console.COLOR bg;
        Console.COLOR fg;
        boolean blink;
        boolean bold;
        char c;

        protected Props() {
            this.bg = VirtualConsole.this.background;
            this.fg = VirtualConsole.this.foreground;
            this.blink = VirtualConsole.this.blink;
            this.bold = VirtualConsole.this.bold;
            this.c = (char)32;
        }

        void set(char c) {
            this.c = c;
            this.bg = VirtualConsole.this.background;
            this.fg = VirtualConsole.this.foreground;
            this.blink = VirtualConsole.this.blink;
            this.bold = VirtualConsole.this.bold;
        }
    }

    private class VirtualInStream
    extends OutputStream {
        private VirtualInStream() {
        }

        @Override
        public void write(int b) throws IOException {
            VirtualConsole.this.fillInputBuffer((char)b);
        }
    }

    private class VirtualOutStream
    extends OutputStream {
        private VirtualOutStream() {
        }

        @Override
        public void write(int b) throws IOException {
            VirtualConsole.this.writeChar((char)b);
        }
    }
}

