/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.annotations.activator.DefaultImplementation;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.console.ConsoleFactory;
import de.mhus.lib.core.console.ConsoleProgressBar;
import de.mhus.lib.core.console.SimpleConsole;
import de.mhus.lib.core.lang.IBase;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

@DefaultImplementation(value=SimpleConsole.class)
public abstract class Console
extends PrintStream
implements IBase {
    public static int DEFAULT_WIDTH = 200;
    public static int DEFAULT_HEIGHT = 25;
    private static ThreadLocal<Console> consoles = new ThreadLocal();
    protected LinkedList<String> history = new LinkedList();

    public Console() {
        this(System.out);
    }

    public Console(PrintStream out) {
        super(out);
    }

    public Console(PrintStream out, boolean flush, String charset) throws UnsupportedEncodingException {
        super((OutputStream)out, flush, charset);
    }

    public static Console create() {
        Console console = consoles.get();
        if (console == null) {
            ConsoleFactory factory = MApi.lookup(ConsoleFactory.class);
            console = factory.create();
            consoles.set(console);
        }
        return console;
    }

    public String readLine() {
        return this.readLine(this.history);
    }

    public abstract String readLine(LinkedList<String> var1);

    public String readPassword() throws IOException {
        return new String(System.console().readPassword());
    }

    public void cr() {
        this.print('\r');
    }

    public abstract boolean isSupportSize();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract boolean isSupportCursor();

    public abstract void setCursor(int var1, int var2);

    public abstract int getCursorX();

    public abstract int getCursorY();

    public ConsoleProgressBar createProgressBar() {
        return new ConsoleProgressBar(this);
    }

    public abstract boolean isSupportColor();

    public abstract void setColor(COLOR var1, COLOR var2);

    public abstract COLOR getForegroundColor();

    public abstract COLOR getBackgroundColor();

    public abstract boolean isSupportBlink();

    public abstract void setBlink(boolean var1);

    public abstract boolean isBlink();

    public abstract boolean isSupportBold();

    public abstract void setBold(boolean var1);

    public abstract boolean isBold();

    public abstract void cleanup();

    public void printLine() {
        this.printLine('-');
    }

    public void printLine(char c) {
        int i = 0;
        while (i < this.getWidth()) {
            this.print(c);
            ++i;
        }
        this.println();
    }

    public void resetTerminal() {
    }

    public static void resetConsole() {
        consoles.remove();
    }

    public static synchronized Console get() {
        Console console = consoles.get();
        if (console == null) {
            Console.create();
            console = consoles.get();
        }
        return console;
    }

    public static synchronized void set(Console console) {
        consoles.set(console);
    }

    public boolean isInitialized() {
        Console console = consoles.get();
        return console != null;
    }

    public boolean isAnsi() {
        return false;
    }

    public void setWidth(int w) {
    }

    public void setHeight(int h) {
    }

    public static enum COLOR {
        UNKNOWN,
        WHITE,
        BLACK,
        RED,
        GREEN,
        BLUE,
        YELLOW,
        MAGENTA,
        CYAN;

    }
}

