/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.logging.MLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import jline.console.ConsoleReader;

public class ANSIConsole
extends Console {
    protected Console.COLOR foreground;
    protected Console.COLOR background;
    protected boolean blink;
    protected boolean bold;
    protected ConsoleReader reader = new ConsoleReader();
    protected int width = 0;
    protected int height = 0;
    protected boolean supportSize;

    public ANSIConsole() throws IOException {
        this.loadSettings();
    }

    protected void loadSettings() {
        int w = this.reader.getTerminal().getWidth();
        int h = this.reader.getTerminal().getHeight();
        if (w == 80 && h == 24) {
            this.width = DEFAULT_WIDTH;
            this.height = DEFAULT_HEIGHT;
            this.supportSize = false;
        } else {
            this.width = 0;
            this.height = 0;
            this.supportSize = true;
        }
    }

    public ANSIConsole(InputStream in, PrintStream out, boolean flush, String charset) throws IOException {
        super(out, flush, charset);
        this.loadSettings();
    }

    public ANSIConsole(InputStream in, PrintStream out) throws IOException {
        super(out);
        this.loadSettings();
    }

    @Override
    public String readPassword() throws IOException {
        return this.reader.readLine(Character.valueOf('*'));
    }

    @Override
    public String readLine(LinkedList<String> history) {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            MLogUtil.log().t(e);
            return null;
        }
    }

    @Override
    public boolean isSupportSize() {
        return this.supportSize;
    }

    @Override
    public int getWidth() {
        if (this.width > 0) {
            return this.width;
        }
        return this.reader.getTerminal().getWidth();
    }

    @Override
    public int getHeight() {
        if (this.height > 0) {
            return this.height;
        }
        return this.reader.getTerminal().getHeight();
    }

    @Override
    public boolean isSupportCursor() {
        return true;
    }

    @Override
    public void setCursor(int x, int y) {
        this.print(ANSIConsole.ansiSetCursor(x, y));
    }

    public static String ansiSetCursor(int x, int y) {
        return "\u001b[" + y + ";" + x + "H";
    }

    @Override
    public int getCursorX() {
        return -1;
    }

    @Override
    public int getCursorY() {
        return -1;
    }

    @Override
    public boolean isSupportColor() {
        return this.reader.getTerminal().isAnsiSupported();
    }

    @Override
    public void setColor(Console.COLOR foreground, Console.COLOR background) {
        this.foreground = foreground;
        this.background = background;
        if (this.isSupportColor()) {
            if (foreground != null && foreground != Console.COLOR.UNKNOWN) {
                this.print(ANSIConsole.ansiForeground(foreground));
            }
            if (background != null && background != Console.COLOR.UNKNOWN) {
                this.print(ANSIConsole.ansiBackground(background));
            }
        }
    }

    public static String ansiForeground(Console.COLOR color) {
        return "\u001b[3" + ANSIConsole.ansiColorValue(color) + "m";
    }

    public static String ansiBackground(Console.COLOR color) {
        return "\u001b[4" + ANSIConsole.ansiColorValue(color) + "m";
    }

    @Override
    public Console.COLOR getForegroundColor() {
        return this.foreground;
    }

    @Override
    public Console.COLOR getBackgroundColor() {
        return this.background;
    }

    @Override
    public boolean isSupportBlink() {
        return this.isSupportColor();
    }

    @Override
    public void setBlink(boolean blink) {
        this.blink = blink;
        this.updateAttributes();
    }

    private void updateAttributes() {
        if (this.isSupportColor()) {
            this.print(ANSIConsole.ansiAttributes(this.blink, this.bold));
        }
    }

    public static String ansiAttributes(boolean blink, boolean bold) {
        return "\u001b[0" + (blink ? ";5" : "") + (bold ? ";1" : "") + "m";
    }

    @Override
    public boolean isBlink() {
        return this.blink;
    }

    @Override
    public boolean isSupportBold() {
        return this.isSupportColor();
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
        this.updateAttributes();
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    public static String ansiColorValue(Console.COLOR col) {
        switch (col) {
            case BLACK: {
                return "0";
            }
            case BLUE: {
                return "4";
            }
            case GREEN: {
                return "2";
            }
            case RED: {
                return "1";
            }
            case WHITE: {
                return "7";
            }
            case YELLOW: {
                return "3";
            }
            case CYAN: {
                return "6";
            }
            case MAGENTA: {
                return "5";
            }
        }
        return "7";
    }

    @Override
    public void cleanup() {
        this.bold = false;
        this.blink = false;
        this.foreground = Console.COLOR.UNKNOWN;
        this.background = Console.COLOR.UNKNOWN;
        this.print(ANSIConsole.ansiCleanup());
    }

    public static String ansiCleanup() {
        return "\u001b[0m";
    }

    @Override
    public void resetTerminal() {
        this.print(ANSIConsole.ansiReset());
    }

    public static String ansiReset() {
        return "\u001bc";
    }

    @Override
    public boolean isAnsi() {
        return true;
    }

    public static String[] getRawAnsiSettings() throws IOException {
        ConsoleReader reader = new ConsoleReader();
        return new String[]{"Width: " + reader.getTerminal().getWidth(), "Height: " + reader.getTerminal().getHeight(), "Ansi: " + reader.getTerminal().isAnsiSupported(), "Echo: " + reader.getTerminal().isEchoEnabled(), "Supported: " + reader.getTerminal().isSupported()};
    }

    @Override
    public void setWidth(int w) {
        this.width = w;
    }

    @Override
    public void setHeight(int h) {
        this.height = h;
    }
}

