/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlConfig
extends IConfig {
    private static final long serialVersionUID = 1L;
    protected Element element;
    protected boolean changed = false;
    protected XmlConfig parent;
    protected String name;

    public XmlConfig() {
        try {
            Document doc = MXml.createDocument();
            this.element = doc.createElement("config");
            if (this.element != null) {
                this.name = this.element.getNodeName();
            }
            doc.appendChild(this.element);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Document getDocument() {
        return this.element.getOwnerDocument();
    }

    public XmlConfig(Element elementByPath) {
        this(null, elementByPath);
    }

    public XmlConfig(XmlConfig parent, Element elementByPath) {
        this.parent = parent;
        this.element = elementByPath;
        if (this.element != null) {
            this.name = this.element.getNodeName();
        }
    }

    public void readConfig(Reader file) throws Exception {
        Document config = MXml.loadXml(file);
        file.close();
        if (this.element != null) {
            this.element = config.getDocumentElement();
        }
        this.name = this.element.getNodeName();
    }

    @Override
    public IConfig getNode(String key) {
        Element e = MXml.getElementByPath(this.element, key);
        if (e == null) {
            return null;
        }
        return new XmlConfig(this, e);
    }

    @Override
    public Collection<IConfig> getNodes() {
        NodeList list = MXml.getLocalElements(this.element);
        LinkedList<IConfig> out = new LinkedList<IConfig>();
        int i = 0;
        while (i < list.getLength()) {
            out.add(new XmlConfig(this, (Element)list.item(i)));
            ++i;
        }
        return out;
    }

    @Override
    public Collection<IConfig> getNodes(String key) {
        NodeList list = MXml.getLocalElements(this.element, key);
        LinkedList<IConfig> out = new LinkedList<IConfig>();
        int i = 0;
        while (i < list.getLength()) {
            out.add(new XmlConfig(this, (Element)list.item(i)));
            ++i;
        }
        return out;
    }

    @Override
    public Collection<String> getNodeKeys() {
        NodeList list = MXml.getLocalElements(this.element);
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < list.getLength()) {
            set.add(list.item(i).getNodeName());
            ++i;
        }
        return set;
    }

    @Override
    public Collection<String> getPropertyKeys() {
        NamedNodeMap list = this.element.getAttributes();
        HashSet<String> out = new HashSet<String>();
        int i = 0;
        while (i < list.getLength()) {
            out.add(list.item(i).getNodeName());
            ++i;
        }
        return out;
    }

    @Override
    public void removeProperty(String name) {
        this.element.removeAttribute(name);
    }

    @Override
    public void setProperty(String key, Object val) {
        this.element.setAttribute(MXml.normalizeName(key), MCast.objectToString(val));
    }

    public void writeConfig(Writer configStream) throws Exception {
        this.writeConfig(configStream, false);
    }

    public void writeConfig(Writer configStream, boolean intend) throws Exception {
        MXml.trim(this.element);
        MXml.saveXml(this.element, configStream, intend);
    }

    public XmlConfig createConfig(String name) {
        Element ele = this.element.getOwnerDocument().createElement(name);
        this.element.appendChild(ele);
        return new XmlConfig(this, ele);
    }

    @Override
    public String getProperty(String key) {
        if (this.element == null || key == null) {
            return null;
        }
        String out = this.element.getAttribute(key);
        if (out == null || out.length() == 0) {
            return null;
        }
        return out;
    }

    @Override
    public boolean isProperty(String name) {
        return this.getProperty(name) != null;
    }

    public boolean isConfigChanged() {
        return this.parent == null ? this.changed : this.changed || this.parent.isConfigChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int moveConfig(IConfig config, int newPos) throws MException {
        Node item;
        int i;
        if (!(config instanceof XmlConfig)) {
            throw new MException(new Object[]{"not a xmlconfig"});
        }
        if (((XmlConfig)config).element.getParentNode() != this.element) {
            throw new MException(new Object[]{"not child of this config"});
        }
        NodeList list = MXml.getLocalElements(this.element);
        if (list.getLength() == 1) {
            if (newPos == -102 || newPos == -103 || newPos == 0) {
                return 0;
            }
            throw new MException(new Object[]{"out of range"});
        }
        if (newPos == -102) {
            this.element.removeChild(((XmlConfig)config).element);
            list = MXml.getLocalElements(this.element);
            this.element.insertBefore(((XmlConfig)config).element, list.item(0));
            return 0;
        }
        if (newPos == -103) {
            this.element.removeChild(((XmlConfig)config).element);
            this.element.appendChild(((XmlConfig)config).element);
            return list.getLength() - 1;
        }
        if (newPos == -101) {
            i = 0;
            while (i < list.getLength()) {
                item = list.item(i);
                if (item == ((XmlConfig)config).element) {
                    if (i == list.getLength() - 1) {
                        throw new MException(new Object[]{"out of range"});
                    }
                    Node next = list.item(i + 1);
                    this.element.removeChild(((XmlConfig)config).element);
                    this.element.insertBefore(((XmlConfig)config).element, next);
                    return i + 1;
                }
                ++i;
            }
        }
        if (newPos == -100) {
            i = 0;
            while (i < list.getLength()) {
                item = list.item(i);
                if (item == ((XmlConfig)config).element) {
                    if (i == 0) {
                        throw new MException(new Object[]{"out of range"});
                    }
                    Node before = list.item(i - 1);
                    this.element.removeChild(((XmlConfig)config).element);
                    this.element.insertBefore(((XmlConfig)config).element, before);
                    return i - 1;
                }
                ++i;
            }
        }
        if (newPos < 0 || newPos >= list.getLength()) {
            throw new MException(new Object[]{"out of range"});
        }
        Node before = list.item(newPos);
        if (before == ((XmlConfig)config).element) {
            return newPos;
        }
        this.element.removeChild(((XmlConfig)config).element);
        this.element.insertBefore(((XmlConfig)config).element, before);
        return newPos;
    }

    @Override
    public void removeConfig(IConfig config) throws MException {
        if (!(config instanceof XmlConfig)) {
            throw new MException(new Object[]{"not a xmlconfig"});
        }
        if (((XmlConfig)config).element.getParentNode() != this.element) {
            throw new MException(new Object[]{"not child of this config"});
        }
        this.element.removeChild(((XmlConfig)config).element);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public IConfig getParent() {
        return this.parent;
    }

    public Element getXmlElement() {
        return this.element;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof XmlConfig) {
            return this.element.equals(((XmlConfig)obj).element);
        }
        return super.equals(obj);
    }

    @Override
    public InputStream getInputStream(String key) {
        return null;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public void clear() {
        for (String key : this.keys()) {
            this.element.removeAttribute(key);
        }
    }
}

