/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.concurrent;

import de.mhus.lib.errors.TimeoutRuntimeException;

public class Lock {
    protected Thread lock = null;
    protected String name;
    protected boolean privacy = false;

    public Lock() {
    }

    public Lock(String name, boolean privacy) {
        this.setName(name);
        this.privacy = privacy;
    }

    public Lock(String name) {
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lock() {
        Lock lock = this;
        synchronized (lock) {
            while (true) {
                if (!this.isLocked()) {
                    this.lock = Thread.currentThread();
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void lockWithException(long timeout) {
        if (this.lock(timeout)) {
            return;
        }
        throw new TimeoutRuntimeException(new Object[]{this.name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean lock(long timeout) {
        Lock lock = this;
        synchronized (lock) {
            long start;
            do {
                if (!this.isLocked()) {
                    this.lock = Thread.currentThread();
                    return true;
                }
                start = System.currentTimeMillis();
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (System.currentTimeMillis() - start < timeout);
            return false;
        }
    }

    public void lock(Runnable task) {
        try {
            this.lock();
            task.run();
        }
        finally {
            this.unlock();
        }
    }

    public void lock(Runnable task, long timeout) {
        try {
            this.lockWithException(timeout);
            task.run();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock() {
        Lock lock = this;
        synchronized (lock) {
            block4: {
                if (this.lock == Thread.currentThread()) break block4;
                return false;
            }
            this.lock = null;
            this.notify();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockHard() {
        Lock lock = this;
        synchronized (lock) {
            this.lock = null;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilUnlock() {
        Lock lock = this;
        synchronized (lock) {
            while (true) {
                if (!this.isLocked()) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void waitWithException(long timeout) {
        if (this.waitUntilUnlock(timeout)) {
            return;
        }
        throw new TimeoutRuntimeException(new Object[]{this.name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitUntilUnlock(long timeout) {
        Lock lock = this;
        synchronized (lock) {
            long start;
            do {
                if (!this.isLocked()) {
                    return true;
                }
                start = System.currentTimeMillis();
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (System.currentTimeMillis() - start < timeout);
            return false;
        }
    }

    public boolean isLocked() {
        return this.lock != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Thread getLocker() {
        if (this.privacy) {
            return null;
        }
        return this.lock;
    }

    public boolean isPrivacy() {
        return this.privacy;
    }

    public String toString() {
        return String.valueOf(this.name) + (this.lock != null ? " " + this.lock.getName() : "");
    }
}

