/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.cfg;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MSystem;

public abstract class CfgValue<T> {
    private String path;
    private T def;
    private T value;
    private String owner;

    public CfgValue(Object owner, String path, T def) {
        this.owner = owner instanceof Class ? ((Class)owner).getCanonicalName() : String.valueOf(owner);
        this.path = path;
        this.def = def;
        MApi.getCfgUpdater().register(this);
        this.update();
    }

    public T value() {
        return this.value == null ? this.def : this.value;
    }

    public String getPath() {
        return this.path;
    }

    public String getOwner() {
        return this.owner;
    }

    public T getDefault() {
        return this.def;
    }

    void update() {
        T newValue = this.loadValue();
        if (MSystem.equals(this.value, newValue)) {
            return;
        }
        this.onPreUpdate(newValue);
        this.value = newValue;
        this.onPostUpdate(this.value);
    }

    protected abstract T loadValue();

    protected abstract T loadValue(String var1);

    protected void onPreUpdate(T newValue) {
    }

    protected void onPostUpdate(T newValue) {
    }

    public boolean isOwner(Class<?> name) {
        return this.owner.equals(name.getCanonicalName());
    }

    public boolean isOwner(String name) {
        return this.owner.equals(name);
    }

    public void setValue(String v) {
        T newValue = this.loadValue(v);
        if (newValue == null) {
            return;
        }
        if (MSystem.equals(this.value, newValue)) {
            return;
        }
        this.onPreUpdate(newValue);
        this.value = newValue;
        this.onPostUpdate(this.value);
    }

    public String toString() {
        return String.valueOf(this.value());
    }

    public boolean equals(Object in) {
        if (in != null && in instanceof CfgValue) {
            return MSystem.equals(this.value(), ((CfgValue)in).value());
        }
        return MSystem.equals(this.value(), in);
    }
}

