/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.cfg;

import de.mhus.lib.core.AbstractProperties;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.cfg.CfgValue;
import java.math.BigDecimal;

public class CfgBigDecimal
extends CfgValue<BigDecimal> {
    public CfgBigDecimal(Object owner, String path, BigDecimal def) {
        super(owner, path, def);
    }

    @Override
    protected BigDecimal loadValue() {
        int p = this.getPath().indexOf(64);
        if (p < 0) {
            try {
                return new BigDecimal(MApi.getCfg(this.getOwner()).getString(this.getPath(), ((BigDecimal)this.getDefault()).toString()));
            }
            catch (NumberFormatException e) {
                return (BigDecimal)this.getDefault();
            }
        }
        Object node = MApi.getCfg(this.getOwner()).getNodeByPath(this.getPath().substring(0, p));
        if (node == null) {
            return (BigDecimal)this.getDefault();
        }
        try {
            return new BigDecimal(((AbstractProperties)node).getString(this.getPath().substring(p + 1), ((BigDecimal)this.getDefault()).toString()));
        }
        catch (NumberFormatException e) {
            return (BigDecimal)this.getDefault();
        }
    }

    @Override
    protected BigDecimal loadValue(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return (BigDecimal)this.getDefault();
        }
    }
}

