/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.cast;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.cast.Caster;
import de.mhus.lib.core.logging.Log;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ObjectToCalendar
implements Caster<Object, Calendar> {
    private static final Log log = Log.getLog(ObjectToCalendar.class);

    @Override
    public Class<? extends Calendar> getToClass() {
        return Calendar.class;
    }

    @Override
    public Class<? extends Object> getFromClass() {
        return Object.class;
    }

    @Override
    public Calendar cast(Object in, Calendar def) {
        return this.cast(in, def, Locale.getDefault());
    }

    public Calendar cast(Object in, Calendar def, Locale locale) {
        if (in == null) {
            return def;
        }
        if (in instanceof Calendar) {
            return (Calendar)in;
        }
        if (in instanceof Date) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)in);
            return c;
        }
        try {
            String ins = MCast.toString(in);
            Calendar ret = ObjectToCalendar.toCalendar(ins, locale);
            if (ret == null) {
                return def;
            }
            return ret;
        }
        catch (Throwable t) {
            return def;
        }
    }

    public static Calendar toCalendar(String in, Locale locale) {
        String date;
        Calendar c;
        block48: {
            String[] parts;
            int year;
            int day;
            int month2;
            block49: {
                block47: {
                    if (in == null) {
                        return null;
                    }
                    try {
                        c = Calendar.getInstance();
                        if (in.equals("now") || in.equals("jetzt")) {
                            return c;
                        }
                        boolean retOk = false;
                        c.clear();
                        date = in.trim();
                        int hour = 0;
                        int min = 0;
                        int sec = 0;
                        int millies = 0;
                        String zone = null;
                        int sep = 63;
                        if (MString.isIndex(date, '_')) {
                            sep = 95;
                        } else if (MString.isIndex(date, ' ')) {
                            sep = 32;
                        }
                        if (sep == 32 && MString.isIndex(date, ',')) {
                            int p1 = date.indexOf(32);
                            int p2 = date.indexOf(44);
                            try {
                                month2 = ObjectToCalendar.toMonth(date.substring(0, p1));
                                day = Integer.parseInt(date.substring(p1 + 1, p2).trim());
                                date = date.substring(p2 + 1).trim();
                                p1 = date.indexOf(32);
                                int year2 = Integer.parseInt(date.substring(0, p1).trim());
                                c.set(year2, month2, day);
                                date = " " + date.substring(p1 + 1).trim();
                                sep = 32;
                                retOk = true;
                            }
                            catch (NumberFormatException month2) {
                                // empty catch block
                            }
                        }
                        if (sep != 63) {
                            String[] parts2;
                            String time = MString.afterIndex(date, (char)sep).trim();
                            date = MString.beforeIndex(in, (char)sep).trim();
                            char sep2 = '?';
                            if (MString.isIndex(time, ' ')) {
                                sep2 = ' ';
                            } else if (MString.isIndex(time, '_')) {
                                sep2 = '_';
                            }
                            if (sep2 != '?') {
                                zone = MString.afterIndex(time, sep2);
                                time = MString.beforeIndex(time, sep2);
                            }
                            if (MString.isIndex(time, '.')) {
                                millies = ObjectToCalendar.toint(MString.afterIndex(time, '.'), 0);
                                time = MString.beforeIndex(time, '.');
                            }
                            if ((parts2 = time.split("\\:")).length > 1) {
                                hour = ObjectToCalendar.toint(parts2[0], 0);
                                min = ObjectToCalendar.toint(parts2[1], 0);
                                if (parts2.length > 2) {
                                    sec = ObjectToCalendar.toint(parts2[2], 0);
                                }
                            }
                            c.set(11, hour);
                            c.set(12, min);
                            c.set(14, sec * 1000 + millies);
                        }
                        if (retOk) {
                            return c;
                        }
                        if (date.indexOf(45) > 0) {
                            String[] parts3 = date.split("-");
                            if (zone != null) {
                                TimeZone tz = TimeZone.getTimeZone(zone);
                                c.setTimeZone(tz);
                            }
                            if (parts3.length == 3) {
                                int year3 = Integer.parseInt(parts3[0]);
                                if (parts3[0].length() == 2) {
                                    year3 += 2000;
                                }
                                month2 = ObjectToCalendar.toMonth(parts3[1]);
                                day = Integer.parseInt(parts3[2]);
                                c.set(year3, month2, day);
                            } else if (parts3.length == 2) {
                                c.set(2, ObjectToCalendar.toMonth(parts3[0]));
                                c.set(5, Integer.parseInt(parts3[1]));
                            } else {
                                parts3 = date.split("\\.");
                                if (parts3.length == 3) {
                                    int year4 = Integer.parseInt(parts3[2]);
                                    if (parts3[2].length() == 2) {
                                        year4 += 2000;
                                    }
                                    month2 = ObjectToCalendar.toMonth(parts3[1]);
                                    day = Integer.parseInt(parts3[0]);
                                    c.set(year4, month2, day);
                                } else if (parts3.length == 2) {
                                    int year5 = Integer.parseInt(parts3[1]);
                                    if (parts3[1].length() == 2) {
                                        year5 += 2000;
                                    }
                                    month2 = ObjectToCalendar.toMonth(parts3[0]);
                                    c.set(2, month2);
                                    c.set(1, year5);
                                } else {
                                    parts3 = date.split("/");
                                    if (parts3.length == 3) {
                                        if (Locale.US.equals(locale)) {
                                            c.set(Integer.parseInt(parts3[2]), ObjectToCalendar.toMonth(parts3[0]), Integer.parseInt(parts3[1]));
                                        } else {
                                            c.set(Integer.parseInt(parts3[2]), ObjectToCalendar.toMonth(parts3[1]), Integer.parseInt(parts3[0]));
                                        }
                                    }
                                    if (parts3.length == 2) {
                                        c.set(2, ObjectToCalendar.toMonth(parts3[0]));
                                        c.set(1, Integer.parseInt(parts3[1]));
                                    }
                                }
                            }
                            return c;
                        }
                        if (date.indexOf(46) <= 0) break block47;
                        String[] parts4 = date.split("\\.");
                        if (parts4.length == 3) {
                            year = Integer.parseInt(parts4[2]);
                            if (parts4[2].length() == 2) {
                                year += 2000;
                            }
                            month2 = Integer.parseInt(parts4[1]) - 1;
                            day = Integer.parseInt(parts4[0]);
                            c.set(year, month2, day);
                            return c;
                        }
                        return null;
                    }
                    catch (Throwable e) {
                        log.t(in, e);
                        return null;
                    }
                }
                if (date.indexOf(47) <= 0) break block48;
                parts = date.split("/");
                if (!Locale.US.equals(locale)) break block49;
                if (parts.length == 3) {
                    year = Integer.parseInt(parts[2]);
                    if (parts[2].length() == 2) {
                        year += 2000;
                    }
                    month2 = Integer.parseInt(parts[0]) - 1;
                    day = Integer.parseInt(parts[1]);
                    c.set(year, month2, day);
                    return c;
                }
                return null;
            }
            if (parts.length == 3) {
                year = Integer.parseInt(parts[2]);
                if (parts[2].length() == 2) {
                    year += 2000;
                }
                month2 = Integer.parseInt(parts[1]) - 1;
                day = Integer.parseInt(parts[0]);
                c.set(year, month2, day);
                return c;
            }
            return null;
        }
        try {
            long ts = Long.valueOf(date);
            c.setTimeInMillis(ts);
            return c;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static int toMonth(String in) {
        try {
            int out = Integer.parseInt(in);
            if (out > 0 && out < 13) {
                return out - 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        switch (in = in.toLowerCase()) {
            case "january": 
            case "januar": 
            case "jan": {
                return 0;
            }
            case "februar": 
            case "february": 
            case "feb": {
                return 1;
            }
            case "mrz": 
            case "m\u00e4rz": 
            case "march": {
                return 2;
            }
            case "apr": 
            case "april": {
                return 3;
            }
            case "mai": 
            case "may": {
                return 4;
            }
            case "jun": 
            case "june": 
            case "juni": {
                return 5;
            }
            case "jul": 
            case "juli": 
            case "july": {
                return 6;
            }
            case "august": 
            case "aug": {
                return 7;
            }
            case "september": 
            case "septembre": 
            case "sep": {
                return 8;
            }
            case "october": 
            case "oktober": 
            case "oct": 
            case "okt": {
                return 9;
            }
            case "nov": 
            case "november": {
                return 10;
            }
            case "dec": 
            case "dez": 
            case "december": 
            case "dezember": {
                return 11;
            }
        }
        throw new NumberFormatException(in);
    }

    private static int toint(String in, int def) {
        if (in == null) {
            return def;
        }
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }
}

