/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import java.util.Calendar;
import java.util.Date;

public class MTimeInterval {
    public static final long SECOUND_IN_MILLISECOUNDS = 1000L;
    public static final long MINUTE_IN_MILLISECOUNDS = 60000L;
    public static final long HOUR_IN_MILLISECOUNDS = 3600000L;
    public static final long DAY_IN_MILLISECOUNDS = 86400000L;
    public static final long WEEK_IN_MILLISECOUNDS = 604800000L;
    public static final int MILLISECOND = 1;
    public static final int SECOND = 2;
    public static final int MINUTE = 3;
    public static final int HOUR = 4;
    public static final int DAY = 5;
    public static final int WEEK = 6;
    private long days = 0L;
    private long weeks = 0L;
    private long hours = 0L;
    private long minutes = 0L;
    private long seconds = 0L;
    private long millisec = 0L;

    public MTimeInterval() {
    }

    public MTimeInterval(String _interval) throws NumberFormatException {
        this();
        this.parse(_interval);
    }

    public void parse(String _interval) throws NumberFormatException {
        if (_interval == null) {
            return;
        }
        if (_interval.indexOf(":") > 0) {
            this.add(4, Integer.parseInt(MString.beforeIndex(_interval, ':')));
            _interval = MString.afterIndex(_interval, ':');
            if (_interval.indexOf(":") < 0) {
                this.add(3, Integer.parseInt(_interval));
            } else {
                this.add(3, Integer.parseInt(MString.beforeIndex(_interval, ':')));
                this.add(2, Integer.parseInt(MString.afterIndex(_interval, ':')));
            }
            this.optimize();
            return;
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < _interval.length()) {
            char c = _interval.charAt(i);
            switch (c) {
                case 'w': {
                    this.add(6, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    break;
                }
                case 'd': {
                    this.add(5, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    break;
                }
                case 'h': {
                    this.add(4, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    break;
                }
                case 'M': {
                    this.add(3, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    break;
                }
                case 's': {
                    this.add(2, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    break;
                }
                case 'S': {
                    this.add(1, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\n': 
                case '\r': {
                    this.optimize();
                    return;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        this.optimize();
    }

    public void add(MTimeInterval interval) {
        if (interval == null) {
            return;
        }
        this.parse(interval.toString());
    }

    public void add(int _type, long _value) {
        switch (_type) {
            case 6: {
                this.weeks += _value;
                break;
            }
            case 5: {
                this.days += _value;
                break;
            }
            case 4: {
                this.hours += _value;
                break;
            }
            case 3: {
                this.minutes += _value;
                break;
            }
            case 2: {
                this.seconds += _value;
                break;
            }
            case 1: {
                this.millisec += _value;
            }
        }
    }

    public void optimize() {
        if (this.millisec >= 100L) {
            this.seconds += this.millisec / 100L;
            this.millisec %= 100L;
        }
        if (this.seconds >= 60L) {
            this.minutes += this.seconds / 60L;
            this.seconds %= 60L;
        }
        if (this.minutes >= 60L) {
            this.hours += this.minutes / 60L;
            this.minutes %= 60L;
        }
        if (this.hours >= 24L) {
            this.days += this.hours / 24L;
            this.hours %= 24L;
        }
        if (this.days >= 7L) {
            this.weeks += this.weeks / 7L;
            this.days %= 7L;
        }
        if (this.millisec <= -100L) {
            this.seconds += this.millisec / 100L;
            this.millisec = -(-this.millisec % 100L);
        }
        if (this.seconds <= -60L) {
            this.minutes += this.seconds / 60L;
            this.seconds = -(-this.seconds % 60L);
        }
        if (this.minutes <= -60L) {
            this.hours += this.minutes / 60L;
            this.minutes = -(-this.minutes % 60L);
        }
        if (this.hours <= -24L) {
            this.days += this.hours / 24L;
            this.hours = -(-this.hours % 24L);
        }
        if (this.days <= -7L) {
            this.weeks += this.weeks / 7L;
            this.days = -(-this.days % 7L);
        }
    }

    public Date join(Date _date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(_date);
        this.join(cal);
        return cal.getTime();
    }

    public void join(Calendar _cal) {
        _cal.add(14, (int)this.millisec);
        _cal.add(13, (int)this.seconds);
        _cal.add(12, (int)this.minutes);
        _cal.add(10, (int)this.hours);
        _cal.add(5, (int)(this.days + this.weeks * 7L));
    }

    public String toString() {
        return this.weeks + "w " + this.days + "d " + this.hours + "h " + this.minutes + "M " + this.seconds + "s " + this.millisec + "S";
    }

    public static long toMilliseconds(String interval, int def) {
        if (interval == null) {
            return def;
        }
        try {
            String msec = null;
            String sec = null;
            String min = null;
            String hour = null;
            String day = null;
            if (interval.indexOf(58) > 0) {
                String[] parts = MString.split(interval, ":");
                if (parts.length == 3) {
                    hour = parts[0];
                    min = parts[1];
                    sec = parts[2];
                } else if (parts.length == 2) {
                    min = parts[0];
                    sec = parts[1];
                }
            } else {
                sec = interval;
            }
            if (hour != null && hour.indexOf(32) > 0) {
                day = MString.beforeIndex(hour, ' ');
                hour = MString.afterIndex(hour, ' ');
            }
            if (sec != null && sec.indexOf(46) > 0) {
                msec = MString.afterIndex(sec, '.');
                sec = MString.beforeIndex(sec, '.');
            }
            long out = 0L;
            if (day != null) {
                out += MCast.tolong(day, 0L) * 86400000L;
            }
            if (hour != null) {
                out += MCast.tolong(hour, 0L) * 3600000L;
            }
            if (min != null) {
                out += MCast.tolong(min, 0L) * 60000L;
            }
            if (sec != null) {
                out += MCast.tolong(sec, 0L) * 1000L;
            }
            if (msec != null) {
                out += MCast.tolong(msec, 0L);
            }
            return out;
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public int getMilliseconds() {
        return (int)this.millisec;
    }

    public int getSeconds() {
        return (int)this.seconds;
    }

    public int getMinutes() {
        return (int)this.minutes;
    }

    public int getHours() {
        return (int)this.hours;
    }

    public int getDays() {
        return (int)this.days;
    }

    public int getWeeks() {
        return (int)this.weeks;
    }

    public long getAllMilliseconds() {
        return this.weeks * 7L + this.days * 24L + this.minutes * 60L + this.seconds * 1000L + this.millisec;
    }

    public long getAllSecounds() {
        return this.getAllMilliseconds() / 1000L;
    }

    public long getAllMinutes() {
        return this.getAllMilliseconds() / 1000L / 60L;
    }

    public long getAllDays() {
        return this.getAllMilliseconds() / 1000L / 60L / 24L;
    }

    public long getAllWeeks() {
        return this.getAllMilliseconds() / 1000L / 60L / 24L / 7L;
    }

    public static boolean isTimeOut(long start, long stop, long timeout) {
        return timeout > -1L && stop - start > timeout;
    }

    public static boolean isTimeOut(long start, long timeout) {
        return timeout > -1L && System.currentTimeMillis() - start > timeout;
    }

    public static long toTime(String in, long def) {
        long out = def;
        if (in == null) {
            return out;
        }
        if ((in = in.trim().toLowerCase()).endsWith("m") || in.endsWith("min") || in.endsWith("minutes") || in.endsWith("minute")) {
            return MCast.tolong(MString.integerPart(in), 0L) * 60000L;
        }
        if (in.endsWith("h") || in.endsWith("hour") || in.endsWith("hours")) {
            return MCast.tolong(MString.integerPart(in), 0L) * 3600000L;
        }
        if (in.endsWith("s") || in.endsWith("sec") || in.endsWith("secound") || in.endsWith("secounds")) {
            return MCast.tolong(MString.integerPart(in), 0L) * 1000L;
        }
        if (in.endsWith("d") || in.endsWith("day") || in.endsWith("days")) {
            return MCast.tolong(MString.integerPart(in), 0L) * 86400000L;
        }
        return MCast.tolong(in, def);
    }

    public static String getIntervalAsString(long msec) {
        boolean negative = false;
        if (msec < 0L) {
            negative = true;
            msec = -msec;
        }
        long sec = msec / 1000L;
        long min = sec / 60L;
        long hours = min / 60L;
        long days = hours / 24L;
        long years = days / 365L;
        return String.valueOf(negative ? "-" : "") + (years > 0L ? String.valueOf(MCast.toString(years)) + "y " : "") + MCast.toString((int)(days % 365L), 2) + ' ' + MCast.toString((int)(hours % 24L), 2) + ':' + MCast.toString((int)(min % 60L), 2) + ':' + MCast.toString((int)(sec % 60L), 2) + '.' + MCast.toString((int)(msec % 1000L), 3);
    }

    public static String getIntervalAsStringSec(long msec) {
        long sec = msec / 1000L;
        long min = sec / 60L;
        long hours = min / 60L;
        long days = hours / 24L;
        long years = days / 365L;
        return String.valueOf(years > 0L ? String.valueOf(MCast.toString(years)) + "y " : "") + MCast.toString((int)(days % 365L), 2) + ' ' + MCast.toString((int)(hours % 24L), 2) + ':' + MCast.toString((int)(min % 60L), 2) + ':' + MCast.toString((int)(sec % 60L), 2);
    }

    public static String getIntervalAsStringMin(long msec) {
        long sec = msec / 1000L;
        long min = sec / 60L;
        long hours = min / 60L;
        long days = hours / 24L;
        long years = days / 365L;
        return String.valueOf(years > 0L ? String.valueOf(MCast.toString(years)) + "y " : "") + MCast.toString((int)(days % 365L), 2) + ' ' + MCast.toString((int)(hours % 24L), 2) + ':' + MCast.toString((int)(min % 60L), 2);
    }
}

