/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MHousekeeper;
import de.mhus.lib.core.MHousekeeperTask;
import de.mhus.lib.core.MThreadPool;
import de.mhus.lib.core.MThreadPoolDaemon;
import de.mhus.lib.core.cfg.CfgLong;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.core.lang.MObject;
import java.util.Vector;

public class MThreadPoolManager
extends MObject
implements IBase {
    public static CfgLong CFG_SLEEP_TIME = new CfgLong((Object)MThreadPoolManager.class, "sleepTime", 600000L);
    public static CfgLong CFG_PENDING_TIME = new CfgLong((Object)MThreadPoolManager.class, "pendingTime", 60000L);
    private Vector<MThreadPool.ThreadContainer> pool = new Vector();
    private ThreadGroup group = new ThreadGroup("MThreadPool");
    private ThreadHousekeeper housekeeper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MThreadPool.ThreadContainer start(MThreadPool _task, String _name) {
        MThreadPool.ThreadContainer tc = null;
        Vector<MThreadPool.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            if (this.housekeeper == null) {
                this.housekeeper = new ThreadHousekeeper();
                MApi.lookup(MHousekeeper.class).register(this.housekeeper, (Long)CFG_SLEEP_TIME.value());
            }
            int i = 0;
            while (i < this.pool.size()) {
                if (!this.pool.elementAt(i).isWorking()) {
                    tc = this.pool.elementAt(i);
                    break;
                }
                ++i;
            }
            if (tc == null) {
                tc = new MThreadPool.ThreadContainer(this.group, "AT" + this.pool.size());
                tc.start();
                this.pool.addElement(tc);
            }
            this.log().t("###: NEW THREAD@POOL", tc.getId());
            tc.setName(_name);
            tc.newWork(_task);
        }
        return tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poolClean(long pendingTime) {
        Vector<MThreadPool.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            MThreadPool.ThreadContainer[] list = this.pool.toArray(new MThreadPool.ThreadContainer[this.pool.size()]);
            int i = 0;
            while (i < list.length) {
                long sleep = list[i].getSleepTime();
                if (sleep != 0L && sleep <= pendingTime) {
                    this.pool.remove(list[i]);
                    list[i].stopRunning();
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poolClean() {
        Vector<MThreadPool.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            MThreadPool.ThreadContainer[] list = this.pool.toArray(new MThreadPool.ThreadContainer[this.pool.size()]);
            int i = 0;
            while (i < list.length) {
                if (!list[i].isWorking()) {
                    this.pool.remove(list[i]);
                    list[i].stopRunning();
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poolSize() {
        Vector<MThreadPool.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            return this.pool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poolWorkingSize() {
        int size = 0;
        Vector<MThreadPool.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            MThreadPool.ThreadContainer[] list = this.pool.toArray(new MThreadPool.ThreadContainer[this.pool.size()]);
            int i = 0;
            while (i < list.length) {
                if (list[i].isWorking()) {
                    ++size;
                }
                ++i;
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        this.log().t("finalize");
        Vector<MThreadPool.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            MThreadPool.ThreadContainer[] list;
            MThreadPool.ThreadContainer[] threadContainerArray = list = this.pool.toArray(new MThreadPool.ThreadContainer[this.pool.size()]);
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                MThreadPool.ThreadContainer tc = threadContainerArray[n2];
                tc.stopRunning();
                ++n2;
            }
        }
    }

    private class ThreadHousekeeper
    extends MHousekeeperTask {
        private ThreadHousekeeper() {
        }

        @Override
        public void doit() {
            this.log().t(this.getClass(), "Housekeeper");
            MThreadPoolManager.this.poolClean((Long)CFG_PENDING_TIME.value());
            try {
                MThreadPoolDaemon.poolClean((Long)CFG_PENDING_TIME.value());
            }
            catch (NoClassDefFoundError e) {
                this.log().i("Close stale ThreadHousekeeper", e.toString());
                this.cancel();
            }
        }
    }
}

