/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MThreadPoolManager;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.lang.ValueProvider;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.errors.TimeoutRuntimeException;

public class MThreadPool
extends MObject
implements Runnable {
    protected static Log log = Log.getLog(MThreadPool.class);
    protected Runnable task = this;
    protected String name = "";
    protected ThreadContainer tc = null;

    public MThreadPool() {
    }

    public MThreadPool(String _name) {
        this.name = _name;
    }

    public MThreadPool(Runnable _task) {
        this.task = _task;
    }

    public MThreadPool(Runnable _task, String _name) {
        this.task = _task;
        this.name = _name;
    }

    protected Runnable getTask() {
        return this.task;
    }

    @Override
    public void run() {
    }

    public MThreadPool start() {
        this.tc = MApi.lookup(MThreadPoolManager.class).start(this, this.name);
        return this;
    }

    public void setName(String _name) {
        if (this.tc != null) {
            this.tc.setName(_name);
        }
    }

    public String getName() {
        if (this.tc != null) {
            return this.tc.getName();
        }
        return "";
    }

    public void setPriority(int _p) {
        if (this.tc != null) {
            this.tc.setPriority(_p);
        }
    }

    public int getPriority() {
        if (this.tc != null) {
            return this.tc.getPriority();
        }
        return 0;
    }

    public void stop() {
        if (this.tc == null) {
            return;
        }
        this.tc.stop();
    }

    public void interupt() {
        if (this.tc == null) {
            return;
        }
        this.tc.interrupt();
    }

    public static void sleep(long _millisec) {
        try {
            Thread.sleep(_millisec);
        }
        catch (InterruptedException e) {
            log.i(e);
        }
    }

    private void taskFinish() {
        this.tc = null;
    }

    public void taskError(Throwable t) {
    }

    public static void asynchron(Runnable task) {
        new MThreadPool(task).start();
    }

    public static <T> T getWithTimeout(ValueProvider<T> provider, long timeout, boolean nullAllowed) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                T val = provider.getValue();
                if (nullAllowed || val != null) {
                    return val;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start > timeout) {
                throw new TimeoutRuntimeException(new Object[0]);
            }
            MThreadPool.sleep(200L);
        }
    }

    protected static class ThreadContainer
    extends Thread {
        private boolean running = true;
        private MThreadPool task = null;
        private String name;
        private long sleepStart;
        private String trailConfig;

        public ThreadContainer(ThreadGroup group, String pName) {
            super(group, pName);
            this.name = pName;
            this.setName(String.valueOf(this.name) + " sleeping");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean newWork(MThreadPool _task) {
            ThreadContainer threadContainer = this;
            synchronized (threadContainer) {
                block4: {
                    if (this.task == null && this.running) break block4;
                    return false;
                }
                this.task = _task;
                this.trailConfig = MLogUtil.getTrailConfig();
                this.notify();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWorking() {
            ThreadContainer threadContainer = this;
            synchronized (threadContainer) {
                return this.task != null;
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stopRunning() {
            ThreadContainer threadContainer = this;
            synchronized (threadContainer) {
                block4: {
                    if (this.task == null) break block4;
                    return false;
                }
                this.running = false;
                this.notifyAll();
            }
            return true;
        }

        public long getSleepTime() {
            if (this.task != null) {
                return 0L;
            }
            return System.currentTimeMillis() - this.sleepStart;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                this.sleepStart = System.currentTimeMillis();
                while (this.task == null && this.running) {
                    try {
                        ThreadContainer threadContainer = this;
                        synchronized (threadContainer) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                MThreadPool currentTask = this.task;
                if (this.task != null) {
                    this.setName(String.valueOf(this.name) + '[' + this.getId() + "] " + currentTask.getTask().getClass().getName());
                    if (this.trailConfig != null) {
                        MLogUtil.setTrailConfig(this.trailConfig);
                    }
                    try {
                        log.t("Enter Thread Task");
                        currentTask.getTask().run();
                        log.t("Leave Thread Task");
                    }
                    catch (Throwable t) {
                        try {
                            log.i("Thread Task Error", this.getName(), t);
                            currentTask.taskError(t);
                        }
                        catch (Throwable t2) {
                            log.i("Thread Task Finish Error", this.getName(), t2);
                        }
                    }
                    log.t("###: LEAVE THREAD");
                    MLogUtil.releaseTrailConfig();
                    this.setName(String.valueOf(this.name) + " sleeping");
                }
                if (currentTask != null) {
                    currentTask.taskFinish();
                }
                this.trailConfig = null;
                this.task = null;
            }
        }
    }
}

