/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MCast;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class MSwing {
    public static Color toColor(String string, Color def) {
        Color out = null;
        if (string == null) {
            return def;
        }
        if ("blue".equals(string)) {
            return Color.BLUE;
        }
        if ("green".equals(string)) {
            return Color.GREEN;
        }
        if ("grey".equals(string)) {
            return Color.GRAY;
        }
        if ("yellow".equals(string)) {
            return Color.YELLOW;
        }
        if ("light_grey".equals(string)) {
            return Color.LIGHT_GRAY;
        }
        if ("red".equals(string)) {
            return Color.RED;
        }
        out = Color.getColor(string);
        if (out == null) {
            out = def;
        }
        return out;
    }

    public static BufferedImage toBufferedImage(Image _in) {
        BufferedImage out = new BufferedImage(_in.getWidth(null), _in.getHeight(null), 5);
        Graphics g = out.getGraphics();
        g.drawImage(_in, 0, 0, null);
        _in.flush();
        return out;
    }

    public static BufferedImage toBufferedImage(Image _in, int _width, int _height) {
        BufferedImage out = new BufferedImage(_width, _height, 5);
        Graphics g = out.getGraphics();
        g.drawImage(_in, 0, 0, _width, _height, null);
        _in.flush();
        return out;
    }

    public static String toString(Color _in) {
        return "#" + MCast.toHex2String(_in.getRed()) + MCast.toHex2String(_in.getGreen()) + MCast.toHex2String(_in.getBlue());
    }

    public static String toString(Font _in) {
        return String.valueOf(_in.getFamily()) + "-" + (_in.getStyle() == 1 ? "BOLD" : "") + (_in.getStyle() == 2 ? "ITALIC" : "") + "-" + _in.getSize();
    }

    public static String getSelectedPart(JTextArea text) {
        String s = text.getSelectedText();
        if (s == null) {
            s = text.getText();
            int start = s.lastIndexOf("\n\n", text.getCaretPosition());
            start = start < 0 ? 0 : (start += 2);
            int end = s.indexOf("\n\n", text.getCaretPosition());
            if (end < 0) {
                end = s.length();
            }
            if ((s = s.substring(start, end)) == null) {
                s = text.getText();
            }
        }
        return s;
    }

    public static void halfFrame(Window _frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        _frame.setSize(screenWidth / 2, screenHeight / 2);
    }

    public static void tribleFrame(Window _frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        _frame.setSize(screenWidth * 2 / 3, screenHeight * 2 / 3);
    }

    public static void centerFrame(Window _frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        int width = (int)_frame.getSize().getWidth();
        int height = (int)_frame.getSize().getHeight();
        int x = (screenWidth - width) / 2;
        int y = (screenHeight - height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        _frame.setLocation(x, y);
    }

    public static void centerDialog(Window _frame, JDialog _dialog) {
        int y;
        int x;
        if (_frame != null) {
            Point frameLoc = _frame.getLocation();
            Dimension frameSize = _frame.getSize();
            Dimension diaSize = _dialog.getSize();
            x = (int)(frameLoc.getX() + frameSize.getWidth() / 2.0 - diaSize.getWidth() / 2.0);
            y = (int)(frameLoc.getY() + frameSize.getHeight() / 2.0 - diaSize.getHeight() / 2.0);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int screenWidth = (int)screenSize.getWidth();
            int screenHeight = (int)screenSize.getHeight();
            Dimension diaSize = _dialog.getSize();
            x = (int)(((double)screenWidth - diaSize.getWidth()) / 2.0);
            y = (int)(((double)screenHeight - diaSize.getHeight()) / 2.0);
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        _dialog.setLocation(x, y);
    }

    public static String[] getLookAndFeels() {
        String[] o = new String[]{"System Look And Feel", "Windows Style", "Unix (Motif) Style", "Metal Style", "Plastic XP Style", "Plastic 3D Style", "Plastic Style"};
        return o;
    }

    public static void setLookAndFeel(int _nr) {
        String luf = null;
        try {
            switch (_nr) {
                case 0: {
                    luf = UIManager.getSystemLookAndFeelClassName();
                    break;
                }
                case 1: {
                    luf = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                    break;
                }
                case 2: {
                    luf = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                    break;
                }
                case 3: {
                    luf = "javax.swing.plaf.metal.MetalLookAndFeel";
                }
            }
            System.out.println("Set LuF: " + luf + " " + _nr);
            if (luf != null) {
                UIManager.setLookAndFeel(luf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

