/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.crypt.AsyncKey;
import de.mhus.lib.core.crypt.MCrypt;
import de.mhus.lib.core.crypt.Rot13;
import de.mhus.lib.core.io.TextReader;
import de.mhus.lib.core.vault.MVault;
import de.mhus.lib.core.vault.MVaultUtil;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.errors.MRuntimeException;
import de.mhus.lib.errors.UsageException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.UUID;

public class MPassword {
    public static final int TYPE_DUMMY = 0;
    public static final int TYPE_ROT13 = 1;
    public static final int TYPE_RSA = 2;
    private static final Random random = new Random();

    public static String encode(String in) {
        return MPassword.encode(1, in, null);
    }

    public static String encode(int method, String in, String secret) {
        if (in == null) {
            return null;
        }
        if (MPassword.isEncoded(in)) {
            return in;
        }
        switch (method) {
            case 0: {
                return "`X";
            }
            case 1: {
                return "`B:" + Rot13.encode(in);
            }
            case 2: {
                MVault vault = MVaultUtil.loadDefault();
                VaultEntry entry = vault.getEntry(UUID.fromString(secret));
                if (entry == null) {
                    throw new MRuntimeException(new Object[]{"key not found", secret});
                }
                try {
                    AsyncKey key = entry.adaptTo(AsyncKey.class);
                    return "`C:" + entry.getId() + ":" + MCrypt.encodeWithSalt(key, in);
                }
                catch (Exception e) {
                    throw new MRuntimeException(new Object[]{e});
                }
            }
        }
        return null;
    }

    public static String encode(int method, String in) {
        return MPassword.encode(method, in, null);
    }

    public static boolean isEncoded(String in) {
        if (in == null) {
            return false;
        }
        return in.startsWith("`");
    }

    public static String decode(String in) {
        if (in == null) {
            return null;
        }
        if (!MPassword.isEncoded(in)) {
            return in;
        }
        if (in.startsWith("`B:")) {
            return Rot13.decode(in.substring(3));
        }
        if (in.startsWith("`C:")) {
            int p = (in = in.substring(3)).indexOf(58);
            if (p < 0) {
                throw new UsageException(new Object[]{"key id not found"});
            }
            String keyId = in.substring(0, p);
            in = in.substring(p + 1);
            MVault vault = MVaultUtil.loadDefault();
            VaultEntry entry = vault.getEntry(UUID.fromString(keyId));
            if (entry == null) {
                throw new MRuntimeException(new Object[]{"key not found", keyId});
            }
            try {
                AsyncKey key = entry.adaptTo(AsyncKey.class);
                return MCrypt.decodeWithSalt(key, in);
            }
            catch (Exception e) {
                throw new MRuntimeException(new Object[]{e});
            }
        }
        if (in.startsWith("`X")) {
            throw new MRuntimeException(new Object[]{"try to encode a dummy password"});
        }
        if (in.startsWith("`A")) {
            StringBuilder out = new StringBuilder();
            int i = 2;
            while (i < in.length()) {
                char c = in.charAt(i);
                switch (c) {
                    case '0': {
                        c = '9';
                        break;
                    }
                    case '1': {
                        c = '0';
                        break;
                    }
                    case '2': {
                        c = '1';
                        break;
                    }
                    case '3': {
                        c = '2';
                        break;
                    }
                    case '4': {
                        c = '3';
                        break;
                    }
                    case '5': {
                        c = '4';
                        break;
                    }
                    case '6': {
                        c = '5';
                        break;
                    }
                    case '7': {
                        c = '6';
                        break;
                    }
                    case '8': {
                        c = '7';
                        break;
                    }
                    case '9': {
                        c = '8';
                    }
                }
                out.append(c);
                ++i;
            }
            return out.toString();
        }
        return in;
    }

    public static boolean validatePasswordMD5(String real, String md5) {
        if (md5 == null || real == null || md5.length() < 2) {
            return false;
        }
        return MCrypt.validateMd5WithSalt(md5, real);
    }

    public static String encodePasswordMD5(String real) {
        return MCrypt.md5WithSalt(real);
    }

    public static String sha1(String ... input) throws NoSuchAlgorithmException {
        MessageDigest mDigest = MessageDigest.getInstance("SHA1");
        String[] stringArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String in = stringArray[n2];
            mDigest.update(in.getBytes());
            ++n2;
        }
        byte[] result = mDigest.digest();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < result.length) {
            sb.append(Integer.toString((result[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.print("decoded: ");
            TextReader reader = new TextReader(System.in);
            args = new String[]{reader.readLine()};
        }
        System.out.println("encoded: " + MPassword.encode(args[0]));
    }

    public static String generate(int min, int max, boolean upper, boolean numbers, boolean specials) {
        char[] symbols = new char[72];
        int i = 0;
        int c = 97;
        while (c <= 122) {
            if (c != 108) {
                symbols[i++] = c;
            }
            c = (char)(c + 1);
        }
        if (upper) {
            c = 65;
            while (c <= 90) {
                if (c != 73 && c != 79) {
                    symbols[i++] = c;
                }
                c = (char)(c + 1);
            }
        }
        if (numbers) {
            c = 48;
            while (c <= 57) {
                symbols[i++] = c;
                c = (char)(c + 1);
            }
        }
        if (specials) {
            symbols[i++] = 95;
            symbols[i++] = 45;
            symbols[i++] = 46;
            symbols[i++] = 33;
            symbols[i++] = 43;
            symbols[i++] = 47;
            symbols[i++] = 64;
            symbols[i++] = 35;
            symbols[i++] = 59;
        }
        return MPassword.generate(max == min ? min : random.nextInt(max - min) + max, symbols, i);
    }

    public static String generate(int length, char[] symbols, int symbolLength) {
        char[] buf = new char[length];
        int idx = 0;
        while (idx < buf.length) {
            buf[idx] = symbols[random.nextInt(symbolLength)];
            ++idx;
        }
        return new String(buf);
    }

    public static String generate(int length, String symbols) {
        char[] buf = new char[length];
        int idx = 0;
        while (idx < buf.length) {
            buf[idx] = symbols.charAt(random.nextInt(symbols.length()));
            ++idx;
        }
        return new String(buf);
    }
}

