/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

public class MMath {
    public static final int ROTATE_LEFT = 1;
    public static final int ROTATE_RIGHT = 2;

    public static String toBasis36(long value, int digits) {
        boolean minus;
        StringBuilder sb = new StringBuilder();
        boolean bl = minus = value < 0L;
        if (minus) {
            value = -value;
        }
        while (value > 0L) {
            long nr = value % 36L;
            value /= 36L;
            char c = '\u0000';
            c = nr < 10L ? (char)(48L + nr) : (char)(65L + nr - 10L);
            sb.insert(0, c);
        }
        while (sb.length() < digits) {
            sb.insert(0, '0');
        }
        if (minus) {
            sb.insert(0, '-');
        }
        return sb.toString();
    }

    public static String toBasis36WithIdent(long value, long ident, int digits) {
        boolean minus;
        StringBuilder sb = new StringBuilder();
        if (ident < 0L) {
            ident = -ident;
        }
        while (ident > 0L) {
            long nr = ident % 36L;
            ident /= 36L;
            char c = '\u0000';
            c = nr < 10L ? (char)(48L + nr) : (char)(65L + nr - 10L);
            sb.insert(0, c);
        }
        while (sb.length() < 4) {
            sb.insert(0, '0');
        }
        boolean bl = minus = value < 0L;
        if (minus) {
            value = -value;
        }
        while (value > 0L) {
            long nr = value % 36L;
            value /= 36L;
            char c = '\u0000';
            c = nr < 10L ? (char)(48L + nr) : (char)(65L + nr - 10L);
            sb.insert(0, c);
        }
        while (sb.length() < digits) {
            sb.insert(0, '0');
        }
        if (minus) {
            sb.insert(0, '-');
        }
        return sb.toString();
    }

    public static double truncateDecimals(double d, int len) {
        long p = MMath.pow(10L, len);
        long l = (long)(d * (double)p);
        return (double)l / (double)p;
    }

    public static long pow(long a, int b) {
        long result = 1L;
        int i = 1;
        while (i <= b) {
            result *= a;
            ++i;
        }
        return result;
    }

    public static int unsignetByteToInt(byte b) {
        return b & 0xFF;
    }

    public static int rotr(int data, int distance) {
        return Integer.rotateRight(data, distance);
    }

    public static int rotl(int data, int distance) {
        return Integer.rotateLeft(data, distance);
    }

    public static byte rotr(byte data, int distance) {
        distance &= 8;
        int d = (data & 0xFF) * 256;
        int x = d >> 1;
        return (byte)((x / 256 & 0xFF) + (x & 0xFF));
    }

    public static byte rotl(byte data, int distance) {
        distance &= 8;
        int d = data & 0xFF;
        int x = d << 1;
        return (byte)((x & 0xFF) + x / 256);
    }

    public static byte addRotate(byte b, byte add) {
        return (byte)(((b & 0xFF) * 256 + (add & 0xFF) * 256) / 256);
    }

    public static byte subRotate(byte b, byte add) {
        return (byte)(((b & 0xFF) * 256 - (add & 0xFF) * 256) / 256);
    }
}

