/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.crypt.MCrypt;
import de.mhus.lib.core.util.SecureString;
import de.mhus.lib.core.vault.DefaultEntry;
import de.mhus.lib.core.vault.MutableVaultSource;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.errors.MException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.UUID;

public class FileVaultSource
extends MutableVaultSource {
    private SecureString passphrase;
    private File file;

    public FileVaultSource(File file, String passphrase, String name) throws IOException {
        this(file, passphrase);
        this.name = name;
    }

    public FileVaultSource(File file, String passphrase) throws IOException {
        this.passphrase = new SecureString(passphrase);
        this.file = file;
        if (file.exists()) {
            this.doLoad();
        }
    }

    @Override
    public void doLoad() throws IOException {
        FileInputStream parent = new FileInputStream(this.file);
        InputStream is = MCrypt.createCipherInputStream(parent, this.passphrase.value());
        ObjectInputStream ois = new ObjectInputStream(is);
        this.name = ois.readUTF();
        int size = ois.readInt();
        this.entries.clear();
        for (int i = 0; i < size; ++i) {
            FileEntry entry = new FileEntry(ois);
            try {
                this.addEntry(entry);
                continue;
            }
            catch (MException e) {
                this.log().d(new Object[]{entry, e});
            }
        }
        parent.close();
    }

    @Override
    public void doSave() throws IOException {
        FileOutputStream parent = new FileOutputStream(this.file);
        OutputStream os = MCrypt.createCipherOutputStream(parent, this.passphrase.value());
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeUTF(this.name);
        oos.writeInt(this.entries.size());
        for (VaultEntry entry : this.entries.values()) {
            oos.writeUTF(entry.getId().toString());
            oos.writeUTF(entry.getType());
            oos.writeUTF(entry.getDescription());
            oos.writeUTF(entry.getValue());
        }
        oos.flush();
        parent.close();
    }

    @Override
    public String toString() {
        return MSystem.toString(this, this.name, this.entries.size(), this.file);
    }

    private class FileEntry
    extends DefaultEntry {
        public FileEntry(ObjectInputStream ois) throws IOException {
            this.id = UUID.fromString(ois.readUTF());
            this.type = ois.readUTF();
            this.description = ois.readUTF();
            this.value = new SecureString(ois.readUTF());
        }
    }
}

