/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.util.MapEntry;
import de.mhus.lib.errors.NotSupportedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TimeoutMap<K, V>
implements Map<K, V> {
    private Map<K, Container<V>> map = new HashMap<K, Container<V>>();
    private long timeout = 600000L;
    private long lastCheck = System.currentTimeMillis();
    private long checkTimeout = 600000L;
    private Invalidator<K, V> invalidator;

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.doValidationCheck();
        Container<V> ret = this.map.get(key);
        return ret == null ? null : (V)ret.getValue();
    }

    public long getAccessCount(Object key) {
        this.doValidationCheck();
        Container<V> ret = this.map.get(key);
        return ret == null ? -1L : ret.accessed;
    }

    public synchronized void doValidationCheck() {
        if (System.currentTimeMillis() - this.lastCheck > this.checkTimeout) {
            Iterator<Map.Entry<K, Container<V>>> entries = this.map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<K, Container<V>> next = entries.next();
                if ((this.invalidator == null || !this.invalidator.isInvalid(next.getKey(), next.getValue().value, next.getValue().time, next.getValue().accessed)) && (this.invalidator != null || !next.getValue().isTimeout())) continue;
                entries.remove();
            }
            this.lastCheck = System.currentTimeMillis();
        }
    }

    @Override
    public V put(K key, V value) {
        this.doValidationCheck();
        Container<V> ret = this.map.put(key, new Container<V>(value));
        return ret == null ? null : (V)ret.value;
    }

    @Override
    public V remove(Object key) {
        this.doValidationCheck();
        Container<V> ret = this.map.remove(key);
        return ret == null ? null : (V)ret.value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        this.doValidationCheck();
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.doValidationCheck();
        HashSet<Map.Entry<K, V>> out = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, Container<V>> entry : this.map.entrySet()) {
            out.add(new MapEntry(entry.getKey(), entry.getValue().value));
        }
        return out;
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V ret = this.get(key);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V replace(K key, V value) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new NotSupportedException(new Object[0]);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getCheckTimeout() {
        return this.checkTimeout;
    }

    public void setCheckTimeout(long checkTimeout) {
        this.checkTimeout = checkTimeout;
    }

    public Invalidator<K, V> getInvalidator() {
        return this.invalidator;
    }

    public void setInvalidator(Invalidator<K, V> invalidator) {
        this.invalidator = invalidator;
    }

    public static interface Invalidator<K, V> {
        public boolean isInvalid(K var1, V var2, long var3, long var5);
    }

    private class Container<Z> {
        Z value;
        long time = System.currentTimeMillis();
        long accessed = 0L;

        public Container(Z value) {
            this.value = value;
        }

        public Z getValue() {
            this.time = System.currentTimeMillis();
            ++this.accessed;
            return this.value;
        }

        boolean isTimeout() {
            return System.currentTimeMillis() - this.time > TimeoutMap.this.getTimeout();
        }
    }
}

