/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MStopWatch;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.util.CompareDirEntry;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class CompareDir
extends MObject {
    private boolean fullRefresh;
    private String[] pathes;
    private String[] pathesSlash;
    private int totalSize = 100;
    private int totalCnt;
    private int currentCnt = 0;
    private boolean killed;
    private int insertCnt = 0;
    private int updateCnt = 0;
    private int deleteCnt = 0;
    private boolean commitAfterEveryEvent;
    private boolean commitAfterFinish;
    private boolean needAllFolders;

    public void compare(TreeMap<String, CompareDirEntry> current, TreeMap<String, CompareDirEntry> last, Listener listener) {
        MStopWatch tk = new MStopWatch();
        tk.start();
        this.log().t("START");
        listener.start(current, last);
        this.totalSize = current.size() + last.size();
        this.totalCnt = 0;
        Iterator<Map.Entry<String, CompareDirEntry>> cur = current.entrySet().iterator();
        Iterator<Map.Entry<String, CompareDirEntry>> old = last.entrySet().iterator();
        Map.Entry<String, CompareDirEntry> curEntry = null;
        Map.Entry<String, CompareDirEntry> oldEntry = null;
        String curKey = null;
        CompareDirEntry curVal = null;
        String oldKey = null;
        CompareDirEntry oldVal = null;
        if (cur.hasNext()) {
            curEntry = cur.next();
            curKey = curEntry.getKey();
            curVal = curEntry.getValue();
            this.log().t("CUR", curKey);
            ++this.totalCnt;
            ++this.currentCnt;
        }
        if (old.hasNext()) {
            oldEntry = old.next();
            oldKey = oldEntry.getKey();
            oldVal = oldEntry.getValue();
            this.log().t("OLD", oldKey);
            ++this.totalCnt;
        }
        while (!(curEntry == null && oldEntry == null || this.killed)) {
            boolean ret;
            int comp = 0;
            comp = curEntry != null && oldEntry != null ? curKey.compareTo(oldKey) : (curEntry == null ? 1 : -1);
            if (comp == 0) {
                if ((this.fullRefresh || !curVal.compareWithEntry(oldVal)) && this.isPath(curKey)) {
                    this.log().t("UPDATE");
                    ++this.updateCnt;
                    ret = listener.updateObject(curKey, curVal, oldVal);
                    if (this.commitAfterEveryEvent) {
                        if (ret) {
                            this.doCommit();
                        } else {
                            this.doRollback();
                        }
                    }
                }
                if (cur != null && cur.hasNext()) {
                    curEntry = cur.next();
                    curKey = curEntry.getKey();
                    curVal = curEntry.getValue();
                    this.log().t("CUR,", curKey);
                    ++this.totalCnt;
                    ++this.currentCnt;
                } else {
                    curEntry = null;
                }
                if (old != null && old.hasNext()) {
                    oldEntry = old.next();
                    oldKey = oldEntry.getKey();
                    oldVal = oldEntry.getValue();
                    this.log().t("OLD", oldKey);
                    ++this.totalCnt;
                    continue;
                }
                oldEntry = null;
                continue;
            }
            if (comp > 0) {
                if (this.isPath(oldKey)) {
                    this.log().t("DELETE");
                    ++this.deleteCnt;
                    ret = listener.deleteObject(oldKey, oldVal);
                    if (this.commitAfterEveryEvent) {
                        if (ret) {
                            this.doCommit();
                        } else {
                            this.doRollback();
                        }
                    }
                }
                if (old != null && old.hasNext()) {
                    oldEntry = old.next();
                    oldKey = oldEntry.getKey();
                    oldVal = oldEntry.getValue();
                    this.log().t("OLD", oldKey);
                    ++this.totalCnt;
                    continue;
                }
                oldEntry = null;
                continue;
            }
            if (this.isPath(curKey)) {
                this.log().t("CREATE");
                ++this.insertCnt;
                ret = listener.createObject(curKey, curVal);
                if (this.commitAfterEveryEvent) {
                    if (ret) {
                        this.doCommit();
                    } else {
                        this.doRollback();
                    }
                }
            }
            if (cur != null && cur.hasNext()) {
                curEntry = cur.next();
                curKey = curEntry.getKey();
                curVal = curEntry.getValue();
                this.log().t("CUR", curKey);
                ++this.totalCnt;
                ++this.currentCnt;
                continue;
            }
            curEntry = null;
        }
        this.log().t("FINISH");
        boolean ret = listener.finish(current, last);
        if (this.commitAfterFinish) {
            if (ret) {
                this.doCommit();
            } else {
                this.doRollback();
            }
        }
        tk.stop();
        this.log().d("Time", tk.getCurrentTimeAsString());
    }

    private boolean isPath(String path) {
        if (this.pathes == null) {
            return true;
        }
        path = path.substring(0, path.lastIndexOf(44));
        if (this.needAllFolders) {
            for (int i = 0; i < this.pathes.length; ++i) {
                if (!path.startsWith(this.pathesSlash[i]) && !path.equals(this.pathes[i])) continue;
                return true;
            }
        } else {
            int pos = path.lastIndexOf(47);
            String p = null;
            if (pos > 0) {
                p = path.substring(0, pos);
            }
            for (int i = 0; i < this.pathes.length; ++i) {
                if ((p == null || !p.equals(this.pathes[i])) && !path.equals(this.pathes[i])) continue;
                return true;
            }
        }
        return false;
    }

    public int getProgress() {
        if (this.totalSize == 0) {
            return 100;
        }
        return this.totalCnt * 100 / this.totalSize;
    }

    public long getProgressCount() {
        return this.currentCnt;
    }

    public void kill() {
        this.killed = true;
    }

    public int getDeletedCnt() {
        return this.deleteCnt;
    }

    public int getInsertCnt() {
        return this.insertCnt;
    }

    public int getUpdatedCnt() {
        return this.updateCnt;
    }

    public void doCommit() {
    }

    public void doRollback() {
    }

    public boolean isFullRefresh() {
        return this.fullRefresh;
    }

    public void setFullRefresh(boolean fullRefresh) {
        this.fullRefresh = fullRefresh;
    }

    public String[] getPathes() {
        return this.pathes;
    }

    public void setPathes(String[] pathes) {
        this.pathes = pathes;
        this.pathesSlash = new String[pathes.length];
        for (int i = 0; i < pathes.length; ++i) {
            this.pathesSlash[i] = pathes[i] + '/';
        }
    }

    public boolean isCommitAfterEveryEvent() {
        return this.commitAfterEveryEvent;
    }

    public void setCommitAfterEveryEvent(boolean commitAfterEveryEvent) {
        this.commitAfterEveryEvent = commitAfterEveryEvent;
    }

    public boolean isCommitAfterFinish() {
        return this.commitAfterFinish;
    }

    public void setCommitAfterFinish(boolean commitAfterFinish) {
        this.commitAfterFinish = commitAfterFinish;
    }

    public boolean isNeedAllFolders() {
        return this.needAllFolders;
    }

    public void setNeedAllFolders(boolean needAllFolders) {
        this.needAllFolders = needAllFolders;
    }

    public static interface Listener {
        public void start(TreeMap<String, CompareDirEntry> var1, TreeMap<String, CompareDirEntry> var2);

        public boolean finish(TreeMap<String, CompareDirEntry> var1, TreeMap<String, CompareDirEntry> var2);

        public boolean updateObject(String var1, CompareDirEntry var2, CompareDirEntry var3);

        public boolean createObject(String var1, CompareDirEntry var2);

        public boolean deleteObject(String var1, CompareDirEntry var2);
    }
}

