/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.core.pojo.PojoFilter;
import de.mhus.lib.core.pojo.PojoModelImpl;
import java.lang.annotation.Annotation;

public class AnnotationFilter
implements PojoFilter {
    private Class<? extends Annotation>[] allowed;

    @SafeVarargs
    public AnnotationFilter(Class<? extends Annotation> ... allowed) {
        this.allowed = allowed;
    }

    @Override
    public void filter(PojoModelImpl model) {
        boolean done;
        Object attr;
        for (String name : model.getAttributeNames()) {
            attr = model.getAttribute(name);
            done = false;
            for (Class<? extends Annotation> a : this.allowed) {
                if (attr.getAnnotation(a) == null) continue;
                done = true;
                break;
            }
            if (done) continue;
            model.removeAttribute(name);
        }
        for (String name : model.getActionNames()) {
            attr = model.getAction(name);
            done = false;
            for (Class<? extends Annotation> a : this.allowed) {
                if (attr.getAnnotation(a) == null) continue;
                done = true;
                break;
            }
            if (done) continue;
            model.removeAction(name);
        }
    }
}

