/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.mail;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MPassword;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MTimeInterval;
import de.mhus.lib.core.cfg.CfgBoolean;
import de.mhus.lib.core.cfg.CfgLong;
import de.mhus.lib.core.cfg.CfgString;
import de.mhus.lib.core.mail.MSendMail;
import de.mhus.lib.core.mail.MailAttachment;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class DefaultSendMail
extends MLog
implements MSendMail {
    private static CfgString CFG_MAIL_USER = new CfgString((Object)MSendMail.class, "user", "");
    private static CfgString CFG_MAIL_PASSWORD = new CfgString((Object)MSendMail.class, "password", "");
    private static CfgString CFG_HOST = new CfgString((Object)MSendMail.class, "host", "localhost");
    private static CfgString CFG_PORT = new CfgString((Object)MSendMail.class, "port", "587");
    private static CfgBoolean CFG_TLS = new CfgBoolean((Object)MSendMail.class, "tls", true);
    private static CfgString CFG_FROM = new CfgString((Object)MSendMail.class, "from", "");
    private static CfgLong CFG_CONNECTION_TIMEOUT = new CfgLong((Object)MSendMail.class, "connection.timeout", 60000L);
    private Transport transport;
    private long lastMailTransport;
    private Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() throws MessagingException {
        DefaultSendMail defaultSendMail = this;
        synchronized (defaultSendMail) {
            if (this.transport != null && (MTimeInterval.isTimeOut(this.lastMailTransport, (Long)CFG_CONNECTION_TIMEOUT.value()) || !this.transport.isConnected())) {
                this.reset();
            }
            if (this.session == null || this.transport == null) {
                final Properties properties = new Properties();
                properties.put("mail.transport.protocol", "smtp");
                properties.put("mail.smtp.host", CFG_HOST.value());
                properties.put("mail.smtp.port", CFG_PORT.value());
                if (MString.isSet((String)CFG_MAIL_USER.value())) {
                    properties.put("mail.smtp.auth", "true");
                    properties.put("mail.user", CFG_MAIL_USER.value());
                    properties.put("mail.password", MPassword.decode((String)CFG_MAIL_PASSWORD.value()));
                }
                if (((Boolean)CFG_TLS.value()).booleanValue()) {
                    properties.put("mail.smtp.starttls.enable", (Object)true);
                    properties.put("mail.smtp.ssl.trust", CFG_HOST.value());
                }
                Authenticator auth = null;
                if (MString.isSet((String)CFG_MAIL_USER.value())) {
                    auth = new Authenticator(){

                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(properties.getProperty("mail.user"), properties.getProperty("mail.password"));
                        }
                    };
                }
                this.session = Session.getInstance((Properties)properties, auth);
                this.transport = this.session.getTransport();
                this.transport.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DefaultSendMail defaultSendMail = this;
        synchronized (defaultSendMail) {
            if (this.transport != null) {
                try {
                    this.transport.close();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
            }
            this.transport = null;
            this.session = null;
            this.lastMailTransport = 0L;
        }
    }

    @Override
    public void sendPlainMail(String from, String[] to, String[] cc, String[] bcc, String subject, String content) throws Exception {
        this.connect();
        if (from == null) {
            from = (String)CFG_FROM.value();
        }
        InternetAddress[] toAddresses = new InternetAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            toAddresses[i] = new InternetAddress(to[i]);
        }
        InternetAddress[] ccAddresses = null;
        if (cc != null && cc.length > 0) {
            ccAddresses = new InternetAddress[cc.length];
            for (int i = 0; i < cc.length; ++i) {
                ccAddresses[i] = new InternetAddress(cc[i]);
            }
        }
        InternetAddress[] bccAddresses = null;
        if (bcc != null && bcc.length > 0) {
            bccAddresses = new InternetAddress[bcc.length];
            for (int i = 0; i < bcc.length; ++i) {
                bccAddresses[i] = new InternetAddress(bcc[i]);
            }
        }
        MimeMessage msg = new MimeMessage(this.session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        if (ccAddresses != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        if (bccAddresses != null) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        }
        msg.setSubject(subject, "UTF-8");
        msg.setSentDate(new Date());
        msg.setText(content, "UTF-8");
        Transport.send((Message)msg);
    }

    @Override
    public void sendHtmlMail(String from, String[] to, String[] cc, String[] bcc, String subject, String html, MailAttachment[] attachments) throws Exception {
        this.connect();
        if (from == null) {
            from = (String)CFG_FROM.value();
        }
        InternetAddress[] toAddresses = new InternetAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            toAddresses[i] = new InternetAddress(to[i]);
        }
        InternetAddress[] ccAddresses = null;
        if (cc != null && cc.length > 0) {
            ccAddresses = new InternetAddress[cc.length];
            for (int i = 0; i < cc.length; ++i) {
                ccAddresses[i] = new InternetAddress(cc[i]);
            }
        }
        InternetAddress[] bccAddresses = null;
        if (bcc != null && bcc.length > 0) {
            bccAddresses = new InternetAddress[bcc.length];
            for (int i = 0; i < bcc.length; ++i) {
                bccAddresses[i] = new InternetAddress(bcc[i]);
            }
        }
        MimeMessage msg = new MimeMessage(this.session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        if (ccAddresses != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        if (bccAddresses != null) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        }
        msg.setSubject(subject, "UTF-8");
        msg.setSentDate(new Date());
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setHeader("Content-Type", "text/plain; charset=\"utf-8\"");
        messageBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
        messageBodyPart.setContent((Object)html, "text/html; charset=utf-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (attachments != null) {
            for (MailAttachment attachment : attachments) {
                if (!attachment.getFile().exists() || !attachment.getFile().isFile()) continue;
                MimeBodyPart attachPart = new MimeBodyPart();
                try {
                    attachPart.setFileName(attachment.getName());
                    attachPart.attachFile(attachment.getFile());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                multipart.addBodyPart((BodyPart)attachPart);
            }
        }
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
        if (attachments != null) {
            for (MailAttachment attachment : attachments) {
                if (!attachment.isDeleteAfterSent()) continue;
                try {
                    attachment.getFile().delete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

