/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.jmx;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MHousekeeper;
import de.mhus.lib.core.MHousekeeperTask;
import de.mhus.lib.core.cfg.CfgBoolean;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.jmx.JmxObject;
import de.mhus.lib.core.jmx.JmxPackage;
import de.mhus.lib.core.jmx.MBeanProxy;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.system.CfgManager;
import de.mhus.lib.errors.MException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MRemoteManager
extends MObject
implements IBase {
    private static CfgBoolean jmxEnabled = new CfgBoolean((Object)MRemoteManager.class, "enabled", false);
    private MBeanServer mbs;
    private HashMap<ObjectName, Object> registry = new HashMap();
    private Housekeeper housekeeper = new Housekeeper(this);

    public MRemoteManager() throws MException {
        IConfig config = MApi.lookup(CfgManager.class).getCfg(this, (IConfig)new HashConfig());
        MApi.lookup(MHousekeeper.class).register(this.housekeeper, config.getLong("housekeeper_sleep", 30000L), true);
    }

    public void register(JmxObject object) throws Exception {
        this.register(object, false);
    }

    public void register(JmxObject object, boolean weak) throws Exception {
        if (!((Boolean)jmxEnabled.value()).booleanValue()) {
            return;
        }
        this.open();
        if (object instanceof JmxPackage) {
            ((JmxPackage)object).open(this);
        } else {
            ObjectName on = object.getJmxObjectName();
            this.register(on, object, true, weak);
            object.setJmxRegistered(true);
        }
    }

    public void unregister(JmxObject object) throws Exception {
        if (object instanceof JmxPackage) {
            ((JmxPackage)object).close();
        } else {
            ObjectName on = object.getJmxObjectName();
            this.unregister(on);
            object.setJmxRegistered(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ObjectName name, Object object, boolean capsulate, boolean weak) throws Exception {
        Object proxy = object;
        if (capsulate) {
            proxy = new MBeanProxy(object, null, this, name, weak);
        }
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            if (this.mbs != null) {
                try {
                    this.log().i("register", name);
                    this.mbs.registerMBean(proxy, name);
                }
                catch (InstanceAlreadyExistsException e) {
                    if (object instanceof JmxObject) {
                        while (true) {
                            String n = ((JmxObject)object).getJmxName();
                            int pos = n.lastIndexOf(45);
                            int nr = 1;
                            if (pos > 0) {
                                nr = MCast.toint(n.substring(pos + 1), nr) + 1;
                                n = n.substring(0, pos);
                            }
                            ((JmxObject)object).setJmxName(n + "-" + nr);
                            name = ((JmxObject)object).getJmxObjectName();
                            if (proxy instanceof MBeanProxy) {
                                ((MBeanProxy)proxy).setName(name);
                            }
                            try {
                                this.mbs.registerMBean(proxy, name);
                                this.log().t("renamed", name);
                            }
                            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                                continue;
                            }
                            break;
                        }
                    }
                    this.log().d(name, e);
                    throw e;
                }
                catch (Exception e) {
                    this.log().d(name, e);
                    throw e;
                }
            }
            this.registry.put(name, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ObjectName name) {
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            this.registry.remove(name);
            if (this.mbs != null) {
                try {
                    this.log().t("unregister", name);
                    this.mbs.unregisterMBean(name);
                }
                catch (Exception e) {
                    this.log().i(name, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            if (this.mbs != null) {
                return;
            }
            this.mbs = ManagementFactory.getPlatformMBeanServer();
            for (Map.Entry<ObjectName, Object> item : this.registry.entrySet()) {
                try {
                    this.log().t("register", item.getKey());
                    this.mbs.registerMBean(item.getValue(), item.getKey());
                }
                catch (Exception e) {
                    this.log().i(item.getKey(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            if (this.mbs == null) {
                return;
            }
            for (Map.Entry<ObjectName, Object> item : this.registry.entrySet()) {
                try {
                    this.log().t("unregister", item.getKey());
                    this.mbs.unregisterMBean(item.getKey());
                }
                catch (Exception e) {
                    this.log().i(item.getKey(), e);
                }
            }
            this.mbs = null;
        }
    }

    public boolean isOpen() {
        return this.mbs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            for (Map.Entry<ObjectName, Object> item : new HashMap<ObjectName, Object>(this.registry).entrySet()) {
                if (!(item.getValue() instanceof MBeanProxy)) continue;
                ((MBeanProxy)item.getValue()).check();
            }
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    private static class Housekeeper
    extends MHousekeeperTask {
        private WeakReference<MRemoteManager> manager;

        private Housekeeper(MRemoteManager manager) {
            this.manager = new WeakReference<MRemoteManager>(manager);
        }

        @Override
        public void doit() throws Exception {
            MRemoteManager obj = (MRemoteManager)this.manager.get();
            if (obj == null) {
                this.log().t("close");
                this.cancel();
                return;
            }
            this.log().t("Housekeeping");
            try {
                obj.check();
            }
            catch (Throwable t) {
                this.log().t(t);
            }
        }
    }
}

