/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.io.FileChecker;
import java.io.File;

public class PdfChecker
extends MLog {
    public FileChecker.SUSPICIOUS isSuspicious(File pdfFile) {
        String content = MFile.readFile(pdfFile);
        int score = this.isSuspicious(content);
        if (score == 0) {
            return FileChecker.SUSPICIOUS.NO;
        }
        if (score == 1) {
            return FileChecker.SUSPICIOUS.MAYBE;
        }
        return FileChecker.SUSPICIOUS.YES;
    }

    public int isSuspicious(String content) {
        String[] lines = MString.split(content, "\n");
        return this.isSuspicious(lines);
    }

    public int isSuspicious(String[] lines) {
        int score = 0;
        int jsCnt = 0;
        int javaScriptCnt = 0;
        int aaCnt = 0;
        int openActionCnt = 0;
        int pageCnt = 0;
        for (String line : lines) {
            if (!line.startsWith("<<")) continue;
            if (line.contains("/JS")) {
                ++jsCnt;
            }
            if (line.contains("/JavaScript")) {
                ++javaScriptCnt;
            }
            if (line.contains("/AA")) {
                ++aaCnt;
            }
            if (line.contains("/OpenAction")) {
                ++openActionCnt;
            }
            if (!line.contains("/Page") || line.contains("/Pages")) continue;
            ++pageCnt;
        }
        if (aaCnt > 0 || openActionCnt > 0) {
            if (score < 3) {
                score += 2;
            } else if (score < 5) {
                ++score;
            }
        }
        if (jsCnt > 0 || javaScriptCnt > 0) {
            if (score < 3) {
                score += 2;
            } else if (score < 5) {
                ++score;
            }
        }
        if (pageCnt == 1 && score > 0 && score < 5) {
            ++score;
        }
        return score;
    }
}

