/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.crypt.MRandom;
import de.mhus.lib.core.logging.MLogUtil;
import java.security.SecureRandom;
import java.util.Random;

public class DefaultRandom
implements MRandom {
    private Random rand;
    private SecureRandom secureRandom;

    @Override
    public byte getByte() {
        return (byte)(Math.random() * 255.0);
    }

    @Override
    public int getInt() {
        return (int)(Math.random() * 2.147483647E9);
    }

    @Override
    public double getDouble() {
        return Math.random();
    }

    @Override
    public long getLong() {
        return (long)(Math.random() * 9.223372036854776E18);
    }

    public synchronized Random getRandom() {
        if (this.rand == null) {
            this.rand = new Random(this.getLong());
        }
        return this.rand;
    }

    @Override
    public <T> T adaptTo(Class<? extends T> ifc) {
        if (Random.class.isAssignableFrom(ifc)) {
            return (T)this.getRandom();
        }
        return null;
    }

    @Override
    public char getChar() {
        return MString.CHARS_READABLE[this.getInt() % MString.CHARS_READABLE.length];
    }

    @Override
    public SecureRandom getSecureRandom() {
        try {
            this.secureRandom = SecureRandom.getInstanceStrong();
        }
        catch (Exception e) {
            MLogUtil.log().e(e);
        }
        return this.secureRandom;
    }
}

