/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MMath;
import de.mhus.lib.core.crypt.CipherBlock;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream
extends InputStream {
    private InputStream is;
    private CipherBlock cipher;

    public CipherInputStream(InputStream is) {
        this.is = is;
    }

    public CipherInputStream(InputStream is, CipherBlock cipher) {
        this.is = is;
        this.cipher = cipher;
    }

    @Override
    public int read() throws IOException {
        int out = this.is.read();
        if (out < 0 || this.cipher == null) {
            return out;
        }
        return MMath.unsignetByteToInt(this.cipher.decode((byte)out));
    }

    public CipherBlock getCipher() {
        return this.cipher;
    }

    public void setCipher(CipherBlock cipher) {
        this.cipher = cipher;
    }
}

