/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.console.ANSIConsole;
import java.io.IOException;

public class XTermConsole
extends ANSIConsole {
    public XTermConsole() {
    }

    public XTermConsole(boolean supportColor) {
        super(supportColor);
    }

    @Override
    public void resetTerminal() {
        try {
            Runtime.getRuntime().exec("clear");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String[] getRawSettings() throws IOException {
        String[] ret = MSystem.execute("/bin/sh", "-c", "stty -a < /dev/tty");
        return ret;
    }

    @Override
    public void loadSettings() {
        try {
            String[] ret = this.getRawSettings();
            String[] parts = ret[0].split("\n");
            if (parts.length > 0) {
                String[] parts2;
                for (String p : parts2 = parts[0].split(";")) {
                    if ((p = p.trim()).endsWith(" rows")) {
                        this.height = MCast.toint(MString.beforeIndex(p, ' '), DEFAULT_HEIGHT);
                        continue;
                    }
                    if (p.endsWith(" columns")) {
                        this.width = MCast.toint(MString.beforeIndex(p, ' '), DEFAULT_WIDTH);
                        continue;
                    }
                    if (p.startsWith("rows ")) {
                        this.height = MCast.toint(MString.afterIndex(p, ' '), DEFAULT_HEIGHT);
                        continue;
                    }
                    if (!p.startsWith("columns ")) continue;
                    this.width = MCast.toint(MString.afterIndex(p, ' '), DEFAULT_WIDTH);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

