/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.annotations.activator.DefaultImplementation;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.console.ANSIConsole;
import de.mhus.lib.core.console.CmdConsole;
import de.mhus.lib.core.console.ConsoleProgressBar;
import de.mhus.lib.core.console.SimpleConsole;
import de.mhus.lib.core.console.XTermConsole;
import de.mhus.lib.core.lang.IBase;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

@DefaultImplementation(value=SimpleConsole.class)
public abstract class Console
extends PrintStream
implements IBase {
    public static int DEFAULT_WIDTH = 40;
    public static int DEFAULT_HEIGHT = 25;
    private static CONSOLE_TYPE consoleType = null;
    private static Console console = null;
    protected LinkedList<String> history = new LinkedList();

    public Console() {
        this(System.out);
    }

    public Console(PrintStream out) {
        super(out);
    }

    public Console(PrintStream out, boolean flush, String charset) throws UnsupportedEncodingException {
        super((OutputStream)out, flush, charset);
    }

    public static Console create() {
        if (Console.getConsoleType() == null) {
            String term = System.getenv("TERM");
            if (term != null) {
                if ((term = term.toLowerCase()).indexOf("xterm") >= 0) {
                    if (term.indexOf("color") > 0) {
                        Console.setConsoleType(CONSOLE_TYPE.XTERM_COLOR);
                    } else {
                        Console.setConsoleType(CONSOLE_TYPE.XTERM);
                    }
                } else {
                    Console.setConsoleType(CONSOLE_TYPE.ANSI_COLOR);
                }
            }
            if (Console.getConsoleType() == null) {
                Console.setConsoleType(CONSOLE_TYPE.SIMPLE);
            }
        }
        if (console == null) {
            console = Console.create(Console.getConsoleType());
        }
        return console;
    }

    public static Console create(CONSOLE_TYPE consoleType) {
        if (consoleType != null) {
            switch (consoleType) {
                case ANSI: {
                    return new ANSIConsole(false);
                }
                case CMD: {
                    return new CmdConsole();
                }
                case SIMPLE: {
                    return new SimpleConsole();
                }
                case XTERM: {
                    return new XTermConsole(false);
                }
                case ANSI_COLOR: {
                    return new ANSIConsole(true);
                }
                case XTERM_COLOR: {
                    return new XTermConsole(true);
                }
            }
            return new SimpleConsole();
        }
        if (MSystem.isWindows()) {
            return new CmdConsole();
        }
        String term = System.getenv("TERM");
        if (term != null) {
            if ((term = term.toLowerCase()).indexOf("xterm") >= 0) {
                return new XTermConsole(term.indexOf("color") > 0);
            }
            if (term.indexOf("ansi") >= 0) {
                return new ANSIConsole(true);
            }
        }
        return new SimpleConsole();
    }

    public String readLine() {
        return this.readLine(this.history);
    }

    public abstract String readLine(LinkedList<String> var1);

    public char[] readPassword() {
        return System.console().readPassword();
    }

    public void cr() {
        this.print('\r');
    }

    public abstract boolean isSupportSize();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract boolean isSupportCursor();

    public abstract void setCursor(int var1, int var2);

    public abstract int getCursorX();

    public abstract int getCursorY();

    public ConsoleProgressBar createProgressBar() {
        return new ConsoleProgressBar(this);
    }

    public abstract boolean isSupportColor();

    public abstract void setColor(COLOR var1, COLOR var2);

    public abstract COLOR getForegroundColor();

    public abstract COLOR getBackgroundColor();

    public abstract boolean isSupportBlink();

    public abstract void setBlink(boolean var1);

    public abstract boolean isBlink();

    public abstract boolean isSupportBold();

    public abstract void setBold(boolean var1);

    public abstract boolean isBold();

    public abstract void cleanup();

    public void printLine() {
        this.printLine('-');
    }

    public void printLine(char c) {
        for (int i = 0; i < this.getWidth(); ++i) {
            this.print(c);
        }
        this.println();
    }

    public void resetTerminal() {
    }

    public static CONSOLE_TYPE getConsoleType() {
        return consoleType;
    }

    public static void setConsoleType(CONSOLE_TYPE consoleType) {
        Console.consoleType = consoleType;
    }

    public static void resetConsole() {
        consoleType = null;
        console = null;
    }

    public static Console get() {
        if (console == null) {
            Console.create();
        }
        return console;
    }

    public boolean isInitialized() {
        return console != null;
    }

    public boolean isAnsi() {
        return false;
    }

    public static enum CONSOLE_TYPE {
        SIMPLE,
        ANSI,
        ANSI_COLOR,
        XTERM,
        XTERM_COLOR,
        CMD;

    }

    public static enum COLOR {
        UNKNOWN,
        WHITE,
        BLACK,
        RED,
        GREEN,
        BLUE,
        YELLOW,
        MAGENTA,
        CYAN;

    }
}

