/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.config.DirConfig;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.JsonConfig;
import de.mhus.lib.core.config.JsonConfigFile;
import de.mhus.lib.core.config.PropertiesConfig;
import de.mhus.lib.core.config.PropertiesConfigFile;
import de.mhus.lib.core.config.XmlConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.core.util.MUri;
import java.io.File;
import java.net.URI;
import java.util.HashSet;

public class MConfigFactory
implements IBase {
    public IConfig createConfigFor(File file) throws Exception {
        return this.createConfigFor(file, false);
    }

    public IConfig createConfigFor(File file, boolean include) throws Exception {
        if (include) {
            HashSet<String> included = new HashSet<String>();
            return this.create(file, included);
        }
        return this.create(file);
    }

    protected IConfig create(File file, HashSet<String> included) throws Exception {
        IConfig out = this.create(file);
        included.add(file.getAbsolutePath());
        for (String path : out.getString("__include", "").split(",")) {
            String abs;
            File absolut;
            if (!MString.isSetTrim(path) || (absolut = MFile.getFile(file, path)) == null || included.contains(abs = absolut.getAbsolutePath())) continue;
            IConfig nextOne = this.create(absolut, included);
            for (String key : nextOne.getPropertyKeys()) {
                if (out.containsKey(key)) continue;
                out.setProperty(key, nextOne.get(key));
            }
            included.add(abs);
        }
        return out;
    }

    protected IConfig create(File file) throws Exception {
        if (file.isDirectory()) {
            return new DirConfig(file);
        }
        String key = file.getName();
        if (key.endsWith(".xml")) {
            XmlConfigFile out = new XmlConfigFile(file);
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", file.getAbsolutePath());
            return out;
        }
        if (key.endsWith(".properties")) {
            PropertiesConfigFile out = new PropertiesConfigFile(file);
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", file.getAbsolutePath());
            return out;
        }
        if (key.endsWith(".json")) {
            JsonConfigFile out = new JsonConfigFile(file);
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", file.getAbsolutePath());
            return out;
        }
        return null;
    }

    public IConfig createConfigFor(URI uri) throws Exception {
        if (uri == null) {
            return null;
        }
        String key = uri.getPath();
        if (key == null) {
            key = uri.toString();
        }
        if (key.endsWith(".xml")) {
            XmlConfigFile out = new XmlConfigFile(uri.toURL().openStream());
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", uri.getPath());
            out.setString("__host", uri.getHost());
            out.setInt("__port", uri.getPort());
            out.setString("__user", uri.getUserInfo());
            return out;
        }
        if (key.endsWith(".properties")) {
            PropertiesConfigFile out = new PropertiesConfigFile(uri.toURL().openStream());
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", uri.getPath());
            out.setString("__host", uri.getHost());
            out.setInt("__port", uri.getPort());
            out.setString("__user", uri.getUserInfo());
            return out;
        }
        if (key.endsWith(".json")) {
            JsonConfigFile out = new JsonConfigFile(uri.toURL().openStream());
            out.setName(MFile.getFileNameOnly(key));
            out.setString("__path", uri.getPath());
            out.setString("__host", uri.getHost());
            out.setInt("__port", uri.getPort());
            out.setString("__user", uri.getUserInfo());
            return out;
        }
        return null;
    }

    public IConfig createConfigForFile(String key) throws Exception {
        if (key == null) {
            return null;
        }
        if (key.endsWith(".xml")) {
            return new XmlConfig();
        }
        if (key.endsWith(".properties")) {
            return new PropertiesConfig();
        }
        if (key.endsWith(".json")) {
            return new JsonConfig();
        }
        return null;
    }

    public IConfig toConfig(String configString) throws Exception {
        if (MString.isEmptyTrim(configString)) {
            return new HashConfig();
        }
        if (configString.startsWith("[") || configString.startsWith("{")) {
            return new JsonConfig(configString);
        }
        if (configString.startsWith("<?")) {
            return new XmlConfig(MXml.loadXml(configString).getDocumentElement());
        }
        if (configString.contains("=")) {
            if (configString.contains("&")) {
                return new HashConfig(MUri.explode(configString));
            }
            return new PropertiesConfig(configString);
        }
        return null;
    }
}

