/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.logging.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MSystem {
    private static Log log = Log.getLog(MSystem.class);
    private static ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();

    public static String getHostname() {
        String out = System.getenv().get("COMPUTERNAME");
        if (out == null) {
            out = System.getenv().get("HOSTNAME");
        }
        if (out == null) {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            String name = rt.getName();
            out = MString.afterIndex(name, '@');
        }
        return out;
    }

    public static String getPid() {
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        String name = rt.getName();
        return MString.beforeIndex(name, '@');
    }

    public static Properties loadProperties(Object owner, Properties properties, String propertyFile) {
        log.d("Loading properties", propertyFile);
        if (properties == null) {
            properties = new Properties();
        }
        try {
            URL m_url = MSystem.locateResource(owner, propertyFile);
            if (m_url == null) {
                log.w("Properties file not found", propertyFile);
                return properties;
            }
            log.i("load", m_url);
            InputStream stream = m_url.openStream();
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            log.i("Error loading properties file", propertyFile, e.toString());
        }
        return properties;
    }

    public static URL locateResource(Object owner, String propertyFile) throws IOException {
        File f;
        URL url = null;
        String location = System.getProperty(propertyFile + ".file");
        if (url == null && location != null && (f = new File(location)).exists() && f.isFile()) {
            url = f.toURL();
        }
        if ((f = new File(propertyFile)).exists() && f.isFile()) {
            return f.toURL();
        }
        f = new File("config/" + propertyFile);
        if (f.exists() && f.isFile()) {
            return f.toURL();
        }
        try {
            File f2;
            String configurationPath = System.getenv("CONFIGURATION");
            if (url == null && configurationPath != null && (f2 = new File(configurationPath + "/" + propertyFile)).exists() && f2.isFile()) {
                url = f2.toURL();
            }
        }
        catch (SecurityException configurationPath) {
            // empty catch block
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (url == null && loader != null) {
            url = loader.getResource(propertyFile);
        }
        Class<?> ownerClass = null;
        if (owner != null) {
            ownerClass = owner instanceof Class ? (Class<?>)owner : owner.getClass();
        }
        if (ownerClass != null && url == null) {
            url = ownerClass.getResource("/" + ownerClass.getPackage().getName().replaceAll("\\.", "/") + "/" + propertyFile);
        }
        if (ownerClass != null && url == null) {
            url = ownerClass.getResource(ownerClass.getPackage().getName().replaceAll("\\.", "/") + "/" + propertyFile);
        }
        if (url != null) {
            return url;
        }
        throw new FileNotFoundException("Cannot locate resource: " + propertyFile);
    }

    public static void beep() {
        System.out.print("\u0007");
        System.out.flush();
    }

    public static String findSource(int returns) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > returns) {
            return stack[returns].getClassName();
        }
        return "?";
    }

    public static String findSource() {
        StackTraceElement[] stack;
        for (StackTraceElement step : stack = Thread.currentThread().getStackTrace()) {
            String n = step.getClassName();
            if (n.startsWith("java.lang") || n.startsWith("de.mhus.lib.core")) continue;
            return n;
        }
        return "?";
    }

    public static String findSourceMethod(int returns) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > returns) {
            return stack[returns].getMethodName();
        }
        return "?";
    }

    public static String findSourceMethod() {
        StackTraceElement[] stack;
        for (StackTraceElement step : stack = Thread.currentThread().getStackTrace()) {
            String n = step.getClassName();
            if (n.startsWith("java.lang") || n.startsWith("de.mhus.lib.core")) continue;
            return step.getMethodName();
        }
        return "?";
    }

    public static String getMainClassName() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (!entry.getKey().startsWith("JAVA_MAIN_CLASS")) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String getTmpDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String toString(Object sender, Object ... attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (sender != null) {
            sb.append(sender instanceof String ? sender : sender.getClass().getSimpleName()).append(':');
        }
        boolean first = true;
        for (Object a : attributes) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            MSystem.serialize(sb, a, null);
        }
        sb.append(']');
        return sb.toString();
    }

    public static Throwable serialize(StringBuilder sb, Object o, Throwable error) {
        try {
            if (o == null) {
                sb.append("[null]");
            } else if (o instanceof Throwable) {
                if (error == null) {
                    return (Throwable)o;
                }
                sb.append("[").append(o).append("]");
            } else if (o.getClass().isArray()) {
                sb.append("{");
                for (Object p : (Object[])o) {
                    error = MSystem.serialize(sb, p, error);
                }
                sb.append("}");
            } else {
                sb.append("[").append(o).append("]");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return error;
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotation) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(annotation)) continue;
            return current.getAnnotation(annotation);
        }
        return null;
    }

    public static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public static ScriptResult startScript(File dir, String script, long timeout) {
        log.d("script", dir, script);
        ProcessBuilder pb = new ProcessBuilder(new File(dir, script).getAbsolutePath());
        Map<String, String> env = pb.environment();
        pb.directory(dir);
        ScriptResult out = new ScriptResult();
        try {
            Process p = pb.start();
            out.output = new BufferedReader(new InputStreamReader(p.getInputStream()));
            out.error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            p.waitFor();
            p.destroy();
            out.rc = p.exitValue();
        }
        catch (Throwable t) {
            out.exception = t;
        }
        return out;
    }

    public static String getAppIdent() {
        return MSystem.getHostname() + ":" + MSystem.getPid();
    }

    public static String getObjectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    public static String getClassName(Object obj) {
        Class<?> clazz = MSystem.getMainClass(obj);
        if (clazz == null) {
            return "null";
        }
        return clazz.getCanonicalName();
    }

    public static Class<?> getMainClass(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (obj instanceof Class) {
            clazz = (Class<?>)obj;
        }
        while (clazz != null && clazz.isAnonymousClass()) {
            clazz = clazz.getEnclosingClass();
        }
        if (clazz == null) {
            return null;
        }
        return clazz;
    }

    public static String getTemplateCanonicalName(Class<?> clazz, int index) {
        Type mySuperclass = clazz.getGenericSuperclass();
        if (mySuperclass instanceof ParameterizedType) {
            Type[] templates = ((ParameterizedType)mySuperclass).getActualTypeArguments();
            if (index >= templates.length) {
                return null;
            }
            Type tType = templates[index];
            String templName = tType.getTypeName();
            return templName;
        }
        return null;
    }

    public static <T extends Comparable<T>> int compareTo(T s1, T s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static String freeMemoryAsString() {
        long free = MSystem.freeMemory();
        return MString.toByteDisplayString(free);
    }

    public static String maxMemoryAsString() {
        return MString.toByteDisplayString(Runtime.getRuntime().maxMemory());
    }

    public static String memDisplayString() {
        return MSystem.freeMemoryAsString() + " / " + MSystem.maxMemoryAsString();
    }

    public static long freeMemory() {
        Runtime r = Runtime.getRuntime();
        return r.maxMemory() - r.totalMemory() + r.freeMemory();
    }

    public static Field getDeclaredField(Class<?> clazz, String name) {
        if (clazz == null || name == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(name);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return MSystem.getDeclaredField(clazz.getSuperclass(), name);
        }
    }

    public static Class<?> loadClass(String type, ClassLoader cl) throws ClassNotFoundException {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if ("int".equals(type)) {
            return Integer.TYPE;
        }
        if ("long".equals(type)) {
            return Long.TYPE;
        }
        if ("short".equals(type)) {
            return Short.TYPE;
        }
        if ("double".equals(type)) {
            return Double.TYPE;
        }
        if ("float".equals(type)) {
            return Float.TYPE;
        }
        if ("byte".equals(type)) {
            return Byte.TYPE;
        }
        if ("boolean".equals(type)) {
            return Boolean.TYPE;
        }
        if ("char".equals(type)) {
            return Character.TYPE;
        }
        if ("String".equals(type)) {
            return String.class;
        }
        if ("Date".equals(type)) {
            return Date.class;
        }
        if ("int[]".equals(type)) {
            return int[].class;
        }
        if ("long[]".equals(type)) {
            return long[].class;
        }
        if ("short[]".equals(type)) {
            return short[].class;
        }
        if ("double[]".equals(type)) {
            return double[].class;
        }
        if ("float[]".equals(type)) {
            return float[].class;
        }
        if ("byte[]".equals(type)) {
            return byte[].class;
        }
        if ("boolean[]".equals(type)) {
            return boolean[].class;
        }
        if ("char[]".equals(type)) {
            return char[].class;
        }
        if ("String[]".equals(type)) {
            return String[].class;
        }
        if ("Date[]".equals(type)) {
            return Date[].class;
        }
        boolean array = false;
        if (type.endsWith("[]")) {
            array = true;
            type = type.substring(0, type.length() - 2);
        }
        Class<?> clazz = cl.loadClass(type);
        if (array) {
            clazz = Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }

    public static List<TopThreadInfo> threadTop(long sleep) throws InterruptedException {
        sleep = Math.max(sleep, 200L);
        LinkedList<TopThreadInfo> threads = new LinkedList<TopThreadInfo>();
        for (Map.Entry<Thread, StackTraceElement[]> thread : Thread.getAllStackTraces().entrySet()) {
            threads.add(new TopThreadInfo(tmxb, thread));
        }
        threads.forEach(t -> ((TopThreadInfo)t).start());
        Thread.sleep(sleep);
        threads.forEach(t -> ((TopThreadInfo)t).stop());
        long sumCpu = 0L;
        long sumUser = 0L;
        for (TopThreadInfo t2 : threads) {
            sumCpu += t2.getCpuTime();
            sumUser += t2.getUserTime();
        }
        for (TopThreadInfo t2 : threads) {
            t2.setSumTime(sumUser, sumCpu);
        }
        return threads;
    }

    public static String[] execute(String ... command) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command);
        Process proc = pb.start();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        StringBuilder stdOut = new StringBuilder();
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            stdOut.append(s);
        }
        StringBuilder stdErr = new StringBuilder();
        while ((s = stdError.readLine()) != null) {
            stdErr.append(s);
        }
        return new String[]{stdOut.toString(), stdErr.toString()};
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.contains("Windows");
    }

    public static File getUserHome() {
        String currentUsersHomeDir = System.getProperty("user.home");
        return new File(currentUsersHomeDir);
    }

    public static String setProperty(String key, String value) {
        if (value == null) {
            return System.clearProperty(key);
        }
        return System.setProperty(key, value);
    }

    public static String getProperty(String key) {
        return System.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        return System.getProperty(key, def);
    }

    public static String getCanonicalClassName(Class<?> clazz) {
        if (clazz.isLocalClass()) {
            return clazz.getCanonicalName();
        }
        if (clazz.isAnonymousClass()) {
            return clazz.getName();
        }
        return clazz.getCanonicalName();
    }

    public static Throwable serialize(StringBuilder sb, Object[] msg, int maxMsgSize) {
        Throwable error = null;
        for (Object o : msg) {
            error = MSystem.serialize(sb, o, error);
            if (maxMsgSize <= 0 || sb.length() <= maxMsgSize) continue;
            sb.setLength(maxMsgSize);
            sb.append("...");
            break;
        }
        return error;
    }

    public static boolean isLockedByThread(Object value) {
        if (value == null) {
            return false;
        }
        int objectHash = value.hashCode();
        for (long threadId : tmxb.getAllThreadIds()) {
            ThreadInfo info = tmxb.getThreadInfo(threadId);
            for (LockInfo locks : info.getLockedSynchronizers()) {
                if (locks.getIdentityHashCode() != objectHash) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static class TopThreadInfo {
        private Thread thread;
        private StackTraceElement[] stacktrace;
        private long startTime;
        private ThreadMXBean tmxb;
        private long startUser;
        private long startCpu;
        private long stopTime;
        private long stopUser;
        private long stopCpu;
        private long diffTime;
        private long diffUser;
        private long diffCpu;
        private double perCpu;
        private double perUser;

        private TopThreadInfo(ThreadMXBean tmxb, Map.Entry<Thread, StackTraceElement[]> thread) {
            this.tmxb = tmxb;
            this.thread = thread.getKey();
            this.stacktrace = thread.getValue();
        }

        private void start() {
            this.startTime = System.currentTimeMillis();
            this.startUser = this.tmxb.getThreadUserTime(this.thread.getId());
            this.startCpu = this.tmxb.getThreadCpuTime(this.thread.getId());
        }

        private void stop() {
            this.stopTime = System.currentTimeMillis();
            this.stopUser = this.tmxb.getThreadUserTime(this.thread.getId());
            this.stopCpu = this.tmxb.getThreadCpuTime(this.thread.getId());
            this.diffTime = this.stopTime - this.startTime;
            this.diffUser = this.stopUser - this.startUser;
            this.diffCpu = this.stopCpu - this.startCpu;
        }

        private void setSumTime(long userTime, long cpuTime) {
            if (cpuTime > 0L) {
                this.perCpu = (double)(this.diffCpu * 100L) / (double)cpuTime;
            }
            if (userTime > 0L) {
                this.perUser = (double)(this.diffUser * 100L) / (double)userTime;
            }
        }

        public long getCpuTime() {
            return this.diffCpu;
        }

        public long getUserTime() {
            return this.diffUser;
        }

        public long getInterval() {
            return this.diffTime;
        }

        public double getCpuPercentage() {
            return this.perCpu;
        }

        public double getUserPercentage() {
            return this.perUser;
        }

        public Thread getThread() {
            return this.thread;
        }

        public StackTraceElement[] getStacktrace() {
            return this.stacktrace;
        }

        public long getCpuTotal() {
            return this.stopCpu;
        }
    }

    public static class ScriptResult {
        public Throwable exception;
        public int rc;
        public BufferedReader error;
        public BufferedReader output;
    }
}

