/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.definition.DefRoot;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsBundle;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ComponentAdapterProvider;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.FormControl;
import de.mhus.lib.form.UiInformation;
import java.util.Locale;

public class MForm
extends MObject
implements MNlsProvider {
    private Locale locale = Locale.getDefault();
    private ComponentAdapterProvider adapterProvider;
    protected IConfig model;
    private DataSource dataSource;
    private MNlsBundle nlsBundle;
    private FormControl control;
    private UiInformation informationPane;

    public MForm() {
    }

    public MForm(Locale locale, ComponentAdapterProvider adapterProvider, IConfig model) {
        if (locale != null) {
            this.locale = locale;
        }
        this.adapterProvider = adapterProvider;
        if (model == null) {
            new NullPointerException("model could not be null");
        }
        this.model = model;
    }

    public MForm(DefRoot model) throws MException {
        this.model = model;
        model.build();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ComponentAdapterProvider getAdapterProvider() {
        return this.adapterProvider;
    }

    public IConfig getModel() {
        return this.model;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = MApi.lookup(DataSource.class);
        }
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public synchronized MNls getNls() {
        if (this.nlsBundle == null) {
            return null;
        }
        return this.nlsBundle.getNls(this.locale);
    }

    public void setNlsBundle(MNlsBundle bundle) {
        this.nlsBundle = bundle;
    }

    public void setAdapterProvider(ComponentAdapterProvider adapterProvider) {
        this.adapterProvider = adapterProvider;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public FormControl getControl() {
        if (this.control == null) {
            this.setControl(MApi.lookup(FormControl.class));
        }
        return this.control;
    }

    public void setControl(FormControl control) {
        this.control = control;
        if (control != null) {
            control.attachedForm(this);
        }
    }

    public UiInformation getInformationPane() {
        return this.informationPane;
    }

    public void setInformationPane(UiInformation informationPane) {
        this.informationPane = informationPane;
    }

    public MNlsBundle getNlsBundle() {
        return this.nlsBundle;
    }
}

