/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.AbstractProperties;
import de.mhus.lib.core.IProperties;
import de.mhus.lib.errors.NotSupportedException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PropertiesSubset
extends AbstractProperties {
    private static final long serialVersionUID = 1L;
    private IProperties parent;
    private String prefix;
    private boolean readonly;

    public PropertiesSubset(IProperties parent, String prefix) {
        this(parent, prefix, false);
    }

    public PropertiesSubset(IProperties parent, String prefix, boolean readonly) {
        this.parent = parent;
        this.prefix = prefix;
        this.readonly = readonly;
    }

    @Override
    public Object getProperty(String name) {
        return this.parent.get(this.prefix + name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.parent.isProperty(this.prefix + name);
    }

    @Override
    public void removeProperty(String key) {
        if (this.readonly) {
            throw new NotSupportedException(new Object[0]);
        }
        this.parent.removeProperty(this.prefix + key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.readonly) {
            throw new NotSupportedException(new Object[0]);
        }
        this.parent.put(this.prefix + key, value);
    }

    @Override
    public boolean isEditable() {
        if (this.readonly) {
            return false;
        }
        return this.parent.isEditable();
    }

    @Override
    public Set<String> keys() {
        HashSet<String> out = new HashSet<String>();
        for (String k : this.parent.keys()) {
            if (!k.startsWith(this.prefix)) continue;
            out.add(k);
        }
        return out;
    }

    @Override
    public int size() {
        int cnt = 0;
        for (String k : this.parent.keys()) {
            if (!k.startsWith(this.prefix)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public Collection<Object> values() {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public void clear() {
        for (String key : this.keys()) {
            this.remove(key);
        }
    }
}

