/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.strategy;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.strategy.OperationDescription;
import de.mhus.lib.core.util.MUri;
import java.util.Map;

public class OperationResult {
    public static final long OK = 0L;
    public static final long EMPTY = -10L;
    public static final long BUSY = -11L;
    public static final long NOT_EXECUTABLE = -12L;
    public static final long SYNTAX_ERROR = -13L;
    public static final long USAGE = -14L;
    public static final long INTERNAL_ERROR = -500L;
    public static final long ACCESS_DENIED = -401L;
    public static final long NOT_FOUND = -404L;
    public static final long NOT_SUPPORTED = -505L;
    public static final long WRONG_STATUS = -506L;
    private String operationPath;
    private String caption;
    private String msg;
    private Object result;
    private boolean successful;
    private long returnCode = 0L;
    private OperationDescription nextOperation;

    public OperationResult() {
    }

    public OperationResult(OperationDescription description) {
        if (description != null) {
            this.setOperationPath(description.getGroup() + "/" + description.getId());
            this.setCaption(description.getCaption());
        }
    }

    public String getOperationPath() {
        return this.operationPath;
    }

    public void setOperationPath(String operationPath) {
        this.operationPath = operationPath;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String title) {
        this.caption = title;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public OperationDescription getNextOperation() {
        return this.nextOperation;
    }

    public void setNextOperation(OperationDescription nextOperation) {
        this.nextOperation = nextOperation;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public boolean isResult(Class<?> clazz) {
        return this.result != null && clazz.isInstance(this.result);
    }

    public <T> T getResultAs(Class<T> clazz) {
        return (T)this.result;
    }

    public <T> T getResultAs() {
        return (T)this.result;
    }

    public String toString() {
        return MSystem.toString(this, this.operationPath, this.successful, this.msg, this.nextOperation);
    }

    public long getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(long returnCode) {
        this.returnCode = returnCode;
    }

    public String getMsgCaption() {
        if (MString.isSet(this.msg) && this.msg.startsWith("m=")) {
            Map<String, String> msgParts = MUri.explode(this.msg);
            return msgParts.get("c");
        }
        return null;
    }

    public String getMsgMessage() {
        if (MString.isSet(this.msg) && this.msg.startsWith("m=")) {
            Map<String, String> msgParts = MUri.explode(this.msg);
            return msgParts.get("m");
        }
        return this.msg;
    }
}

