/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.core.ITimerTask;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.base.service.TimerIfc;
import de.mhus.lib.core.schedule.IntervalWithStartTimeJob;
import de.mhus.lib.core.schedule.MutableSchedulerJob;
import de.mhus.lib.core.schedule.OnceJob;
import de.mhus.lib.core.schedule.Scheduler;
import de.mhus.lib.core.schedule.SchedulerJob;
import de.mhus.lib.core.schedule.TimerTaskAdapter;
import java.util.Date;
import java.util.TimerTask;

public class SchedulerTimer
extends Scheduler
implements TimerIfc {
    public SchedulerTimer() {
    }

    public SchedulerTimer(String name) {
        super(name);
    }

    @Override
    public void schedule(TimerTask task, long delay) {
        this.schedule(new OnceJob(System.currentTimeMillis() + delay, (ITimerTask)new TimerTaskAdapter(task)));
    }

    @Override
    public void schedule(TimerTask task, Date time) {
        this.schedule(new OnceJob(time, (ITimerTask)new TimerTaskAdapter(task)));
    }

    @Override
    public void schedule(TimerTask task, long delay, long period) {
        this.schedule(new IntervalWithStartTimeJob(System.currentTimeMillis() + delay, period, new TimerTaskAdapter(task)));
    }

    @Override
    public void schedule(TimerTask task, Date firstTime, long period) {
        this.schedule(new IntervalWithStartTimeJob(firstTime.getTime(), period, new TimerTaskAdapter(task)));
    }

    @Override
    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        this.schedule(new IntervalWithStartTimeJob(System.currentTimeMillis() + delay, period, new TimerTaskAdapter(task)));
    }

    @Override
    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        this.schedule(new IntervalWithStartTimeJob(firstTime.getTime(), period, new TimerTaskAdapter(task)));
    }

    @Override
    public void schedule(String name, TimerTask task, long delay) {
        this.schedule(new OnceJob(System.currentTimeMillis() + delay, (ITimerTask)new TimerTaskAdapter(name, task)));
    }

    @Override
    public void schedule(String name, TimerTask task, Date time) {
        this.schedule(new OnceJob(time, (ITimerTask)new TimerTaskAdapter(name, task)));
    }

    @Override
    public void schedule(String name, TimerTask task, long delay, long period) {
        this.schedule(new IntervalWithStartTimeJob(System.currentTimeMillis() + delay, period, new TimerTaskAdapter(name, task)));
    }

    @Override
    public void schedule(String name, TimerTask task, Date firstTime, long period) {
        this.schedule(new IntervalWithStartTimeJob(firstTime.getTime(), period, new TimerTaskAdapter(name, task)));
    }

    @Override
    public void scheduleAtFixedRate(String name, TimerTask task, long delay, long period) {
        this.schedule(new IntervalWithStartTimeJob(System.currentTimeMillis() + delay, period, new TimerTaskAdapter(name, task)));
    }

    @Override
    public void scheduleAtFixedRate(String name, TimerTask task, Date firstTime, long period) {
        this.schedule(new IntervalWithStartTimeJob(firstTime.getTime(), period, new TimerTaskAdapter(name, task)));
    }

    @Override
    public void schedule(SchedulerJob job) {
        super.schedule(job);
        this.configureDefault(job);
    }

    public void configureDefault(SchedulerJob job) {
        MProperties properties = this.loadConfiguration();
        String n = job.getName();
        for (String key : properties.keys()) {
            String v;
            if (!MString.compareFsLikePattern(n, key) || (v = properties.getString(key, null)) == null) continue;
            this.log().d("configure by config file", n, key, v);
            String[] vv = v.split("\\|");
            if (vv.length > 0 && vv[0].length() > 0) {
                if (vv[0].equals("disabled")) {
                    job.doReschedule(this, -1L);
                } else {
                    ((MutableSchedulerJob)((Object)job)).doReconfigure(vv[0]);
                    job.doReschedule(this, 0L);
                }
            }
            if (vv.length > 1 && vv[1].length() > 0) {
                job.setLogTrailConfig(vv[1]);
            }
            return;
        }
    }

    private MProperties loadConfiguration() {
        MProperties properties = MProperties.load(MApi.get().getSystemProperty("timer.config.file", "mhus-timer.properties"));
        return properties;
    }

    @Override
    public void cancel() {
        this.stop();
    }
}

