/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MBigMath;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MMath;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.crypt.Asn1Util;
import de.mhus.lib.core.crypt.AsyncKey;
import de.mhus.lib.core.crypt.CipherBlockAdd;
import de.mhus.lib.core.crypt.CipherBlockRotate;
import de.mhus.lib.core.crypt.CipherDecodeAsync;
import de.mhus.lib.core.crypt.CipherEncodeAsync;
import de.mhus.lib.core.crypt.CipherInputStream;
import de.mhus.lib.core.crypt.CipherOutputStream;
import de.mhus.lib.core.crypt.MRandom;
import de.mhus.lib.core.crypt.SaltInputStream;
import de.mhus.lib.core.crypt.SaltOutputStream;
import de.mhus.lib.core.logging.Log;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MCrypt {
    private static Log log = Log.getLog(MCrypt.class);

    public static AsyncKey loadPrivateRsaKey(File file) throws IOException {
        String key = MFile.readFile(file);
        return MCrypt.loadPrivateRsaKey(key);
    }

    public static AsyncKey loadPublicRsaKey(File file) throws IOException {
        String key = MFile.readFile(file);
        return MCrypt.loadPublicRsaKey(key);
    }

    public static AsyncKey loadPrivateRsaKey(String key) throws IOException {
        return Asn1Util.loadPrivateRsaKey(key);
    }

    public static AsyncKey loadPublicRsaKey(String key) throws IOException {
        return Asn1Util.loadPublicRsaKey(key);
    }

    public static BigInteger encode(AsyncKey key, BigInteger in) throws IOException {
        if (in.signum() == -1) {
            throw new IOException("Negative values are not allowed");
        }
        BigInteger encoded = MBigMath.binaryPow(in, key.getPublicExponent(), key.getModulus());
        return encoded;
    }

    public static String encodeWithSalt(AsyncKey key, String in) throws IOException {
        byte salt;
        byte[] org = MString.toBytes(in);
        byte[] org2 = new byte[org.length + 1];
        org2[0] = salt = MApi.lookup(MRandom.class).getByte();
        for (int i = 0; i < org.length; ++i) {
            org2[i + 1] = MMath.addRotate(org[i], salt);
        }
        BigInteger[] enc = MCrypt.encodeBytes(key, org2);
        String b = MBigMath.toBase91(enc);
        return "A" + b;
    }

    public static String encode(AsyncKey key, String in) throws IOException {
        byte[] org = MString.toBytes(in);
        BigInteger[] enc = MCrypt.encodeBytes(key, org);
        String b = MBigMath.toBase91(enc);
        return b;
    }

    public static BigInteger[] encodeBytes(AsyncKey key, byte[] in) throws IOException {
        CipherEncodeAsync encoder = new CipherEncodeAsync(key, MApi.lookup(MRandom.class));
        for (int i = 0; i < in.length; ++i) {
            encoder.write(in[i]);
        }
        encoder.close();
        return encoder.toBigInteger();
    }

    public static BigInteger[] encodeBytes(AsyncKey key, BigInteger[] in) throws IOException {
        BigInteger[] out = new BigInteger[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = MCrypt.encode(key, in[i]);
        }
        return out;
    }

    public static BigInteger decode(AsyncKey key, BigInteger in) throws IOException {
        if (in.signum() == -1) {
            throw new IOException("Negative values not allowed");
        }
        BigInteger decoded = MBigMath.binaryPow(in, key.getPrivateExponent(), key.getModulus());
        return decoded;
    }

    public static String decodeWithSalt(AsyncKey key, String in) throws IOException {
        BigInteger[] benc = MBigMath.fromBase91Array(in.substring(1));
        byte[] enc = MCrypt.decodeBytes(key, benc);
        if (in.charAt(0) == 'A') {
            byte[] enc2 = new byte[enc.length - 1];
            byte salt = enc[0];
            for (int i = 0; i < enc2.length; ++i) {
                enc2[i] = MMath.subRotate(enc[i + 1], salt);
            }
            return MString.toString(enc2);
        }
        throw new IOException("Unknown salt algorithm");
    }

    public static String decode(AsyncKey key, String in) throws IOException {
        BigInteger[] benc = MBigMath.fromBase91Array(in);
        byte[] enc = MCrypt.decodeBytes(key, benc);
        return MString.toString(enc);
    }

    public static BigInteger[] decode(AsyncKey key, BigInteger[] in) throws IOException {
        BigInteger[] out = new BigInteger[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = MCrypt.decode(key, in[i]);
        }
        return out;
    }

    public static byte[] decodeBytes(AsyncKey key, BigInteger[] in) throws IOException {
        CipherDecodeAsync decoder = new CipherDecodeAsync(key);
        for (int i = 0; i < in.length; ++i) {
            decoder.write(in[i]);
        }
        decoder.close();
        return decoder.toBytes();
    }

    public static CipherBlockRotate createRandomCipherBlockRotate(int size) {
        CipherBlockRotate out = new CipherBlockRotate(size);
        byte[] b = out.getBlock();
        for (int i = 0; i < b.length; ++i) {
            b[i] = MApi.lookup(MRandom.class).getByte();
        }
        return out;
    }

    public static OutputStream createCipherOutputStream(OutputStream parent, String passphrase) throws IOException {
        return MCrypt.createCipherOutputStream(parent, passphrase, 3);
    }

    public static OutputStream createCipherOutputStream(OutputStream parent, String passphrase, int version) throws IOException {
        if (passphrase == null || passphrase.length() < 1) {
            throw new IOException("passphrase not set");
        }
        if (passphrase.length() < 4) {
            throw new IOException("passphrase smaller then 4");
        }
        byte[] p = MString.toBytes(passphrase);
        if (version < 2 || version > 3) {
            throw new IOException("Cipher version unknown: " + version);
        }
        parent.write(77);
        parent.write(67);
        parent.write(83);
        parent.write(version);
        MRandom random = MApi.lookup(MRandom.class);
        if (version == 2) {
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new SaltOutputStream(new CipherOutputStream(parent, cipher), random, p.length - random.getInt() % (p.length / 2), true);
        }
        if (version == 3) {
            byte pSalt = random.getByte();
            String md5 = MCrypt.md5(pSalt + passphrase);
            p = MString.toBytes(md5 + passphrase);
            parent.write(MMath.unsignetByteToInt(pSalt));
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new SaltOutputStream(new CipherOutputStream(parent, cipher), random, p.length - random.getInt() % (p.length / 2), true);
        }
        throw new IOException("Cipher version unknown: " + version);
    }

    public static InputStream createCipherInputStream(InputStream parent, String passphrase) throws IOException {
        if (passphrase == null || passphrase.length() < 1) {
            throw new IOException("passphrase not set");
        }
        if (passphrase.length() < 4) {
            throw new IOException("passphrase smaller then 4");
        }
        if (parent.read() != 77) {
            throw new IOException("not a crypt stream header");
        }
        if (parent.read() != 67) {
            throw new IOException("not a crypt stream header");
        }
        if (parent.read() != 83) {
            throw new IOException("not a crypt stream header");
        }
        int version = parent.read();
        if (version == 1) {
            int iSalt = parent.read();
            if (iSalt < 0) {
                throw new EOFException();
            }
            byte[] p = MString.toBytes(passphrase);
            byte salt = MMath.subRotate((byte)iSalt, p[0]);
            for (int i = 0; i < p.length; ++i) {
                p[i] = MMath.addRotate(p[i], salt);
            }
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new CipherInputStream(parent, cipher);
        }
        if (version == 2) {
            byte[] p = MString.toBytes(passphrase);
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new SaltInputStream(new CipherInputStream(parent, cipher), true);
        }
        if (version == 3) {
            byte pSalt = (byte)parent.read();
            String md5 = MCrypt.md5(pSalt + passphrase);
            byte[] p = MString.toBytes(md5 + passphrase);
            CipherBlockAdd cipher = new CipherBlockAdd(p);
            return new SaltInputStream(new CipherInputStream(parent, cipher), true);
        }
        throw new IOException("unsupported crypt stream version: " + version);
    }

    public static byte[] obfuscate(byte[] in) {
        byte salt;
        if (in == null) {
            return null;
        }
        if (in.length < 1) {
            return in;
        }
        byte[] out = new byte[in.length + 1];
        out[0] = salt = MApi.lookup(MRandom.class).getByte();
        for (int i = 0; i < in.length; ++i) {
            out[i + 1] = MMath.addRotate(in[i], salt);
        }
        return out;
    }

    public static byte[] unobfuscate(byte[] in) {
        if (in == null) {
            return null;
        }
        if (in.length < 2) {
            return in;
        }
        byte[] out = new byte[in.length - 1];
        byte salt = in[0];
        for (int i = 1; i < in.length; ++i) {
            out[i - 1] = MMath.subRotate(in[i], salt);
        }
        return out;
    }

    public static int getMaxLoad(BigInteger modulus) {
        return modulus.bitLength() / 8;
    }

    public static String md5(String real) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(real.getBytes());
            return MCast.toBinaryString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            log.t(e);
            return null;
        }
    }
}

