/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.io.PipedStream;
import de.mhus.lib.core.io.TextReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;

public class VirtualConsole
extends Console {
    protected int height = DEFAULT_HEIGHT;
    protected int width = DEFAULT_WIDTH;
    private Props[][] buffer = null;
    private int x;
    private int y;
    private Console.COLOR foreground;
    private Console.COLOR background;
    private boolean blink;
    private boolean bold;
    protected boolean echo;
    private PipedStream piped = new PipedStream();
    private TextReader reader = new TextReader(this.piped.getIn());
    private VirtualInStream writerStream = new VirtualInStream();
    private PrintStream writer = new PrintStream(this.writerStream);
    private boolean quiet;

    public VirtualConsole() throws IOException {
        super(new PrintStream(new ByteArrayOutputStream()), true, "ASCII");
        this.out = new VirtualOutStream();
        this.reset();
    }

    public void reset() {
        this.blink = false;
        this.bold = false;
        this.background = Console.COLOR.BLACK;
        this.foreground = Console.COLOR.WHITE;
        this.x = 0;
        this.y = 0;
        this.buffer = new Props[this.height][this.width];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.buffer[y][x] = new Props();
            }
        }
    }

    @Override
    public String readLine(LinkedList<String> history) {
        return this.reader.readLine();
    }

    @Override
    public char[] readPassword() {
        this.quiet = true;
        try {
            String ret = this.readLine();
            char[] cArray = ret.toCharArray();
            return cArray;
        }
        finally {
            this.quiet = false;
        }
    }

    @Override
    public boolean isSupportSize() {
        return true;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void resize(int width, int height) {
        int x;
        int y;
        Props[][] newBuffer = new Props[height][width];
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                newBuffer[y][x] = new Props();
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (y >= height || x >= width) continue;
                newBuffer[y][x] = this.buffer[y][x];
            }
        }
        this.buffer = newBuffer;
        this.width = width;
        this.height = height;
        this.x %= width;
        this.y = Math.min(this.y, height - 1);
    }

    @Override
    public boolean isSupportCursor() {
        return true;
    }

    @Override
    public void setCursor(int x, int y) {
        this.x = x % this.width;
        this.y = Math.min(y, this.height - 1);
    }

    @Override
    public int getCursorX() {
        return this.x;
    }

    @Override
    public int getCursorY() {
        return this.y;
    }

    @Override
    public boolean isSupportColor() {
        return true;
    }

    @Override
    public void setColor(Console.COLOR foreground, Console.COLOR background) {
        this.foreground = foreground;
        this.background = background;
    }

    @Override
    public Console.COLOR getForegroundColor() {
        return this.foreground;
    }

    @Override
    public Console.COLOR getBackgroundColor() {
        return this.background;
    }

    @Override
    public boolean isSupportBlink() {
        return true;
    }

    @Override
    public void setBlink(boolean blink) {
        this.blink = blink;
    }

    @Override
    public boolean isBlink() {
        return this.blink;
    }

    @Override
    public boolean isSupportBold() {
        return true;
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    public PrintStream getInputWriter() {
        return this.writer;
    }

    public String getMonoDisplayAsString() {
        int x;
        StringBuilder out = new StringBuilder();
        out.append("+");
        for (x = 0; x < this.width; ++x) {
            out.append("-");
        }
        out.append("+\n");
        for (int y = 0; y < this.height; ++y) {
            out.append("|");
            for (int x2 = 0; x2 < this.width; ++x2) {
                out.append(this.buffer[y][x2].c);
            }
            out.append("|\n");
        }
        out.append("+");
        for (x = 0; x < this.width; ++x) {
            out.append("-");
        }
        out.append("+");
        return out.toString();
    }

    protected void fillInputBuffer(char c) throws IOException {
        if (!this.quiet) {
            this.writeChar(c);
        }
        this.piped.getOut().write(c);
    }

    protected void writeChar(char c) {
        if (this.echo) {
            System.out.print(c);
        }
        this.x %= this.width;
        this.y = Math.min(this.y, this.height - 1);
        if (c == '\r') {
            this.x = 0;
        } else if (c == '\t') {
            while (this.x % 7 == 0) {
                this.writeChar(' ');
            }
        } else if (c == '\n') {
            this.x = 0;
            if (this.y >= this.height - 1) {
                this.scrollLineUp();
            } else {
                ++this.y;
            }
        } else {
            Props p = this.buffer[this.y][this.x];
            if (p == null) {
                this.buffer[this.y][this.x] = p = new Props();
            }
            p.set(c);
            if (this.x >= this.width - 1) {
                if (this.y >= this.height - 1) {
                    this.scrollLineUp();
                } else {
                    ++this.y;
                }
                this.x = 0;
            } else {
                ++this.x;
            }
        }
        this.x %= this.width;
        this.y = Math.min(this.y, this.height - 1);
    }

    private void scrollLineUp() {
        int i;
        for (i = 0; i < this.height - 1; ++i) {
            this.buffer[i] = this.buffer[i + 1];
        }
        this.buffer[this.height - 1] = new Props[this.width];
        for (i = 0; i < this.width; ++i) {
            this.buffer[this.height - 1][i] = new Props();
        }
    }

    @Override
    public void cleanup() {
        this.bold = false;
        this.blink = false;
        this.foreground = Console.COLOR.WHITE;
        this.background = Console.COLOR.BLACK;
    }

    private class VirtualInStream
    extends OutputStream {
        private VirtualInStream() {
        }

        @Override
        public void write(int b) throws IOException {
            VirtualConsole.this.fillInputBuffer((char)b);
        }
    }

    private class VirtualOutStream
    extends OutputStream {
        private VirtualOutStream() {
        }

        @Override
        public void write(int b) throws IOException {
            VirtualConsole.this.writeChar((char)b);
        }
    }

    protected class Props {
        Console.COLOR bg;
        Console.COLOR fg;
        boolean blink;
        boolean bold;
        char c;

        protected Props() {
            this.bg = VirtualConsole.this.background;
            this.fg = VirtualConsole.this.foreground;
            this.blink = VirtualConsole.this.blink;
            this.bold = VirtualConsole.this.bold;
            this.c = (char)32;
        }

        void set(char c) {
            this.c = c;
            this.bg = VirtualConsole.this.background;
            this.fg = VirtualConsole.this.foreground;
            this.blink = VirtualConsole.this.blink;
            this.bold = VirtualConsole.this.bold;
        }
    }
}

