/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.base.service;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MDate;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.base.service.HolidayProviderIfc;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class HolidayProviderImpl
extends MLog
implements HolidayProviderIfc {
    private HashMap<String, Map<String, String>> days = new HashMap();

    @Override
    public boolean isHoliday(Locale locale, Date date) {
        Map<String, String> map = this.getHolidays(locale, date.getYear() + 1900);
        if (map == null) {
            return false;
        }
        return map.containsKey(date.getDate() + "." + (date.getMonth() + 1));
    }

    @Override
    public boolean isWorkingDay(Locale locale, Date date) {
        return date.getDay() != 0 && !this.isHoliday(locale, date);
    }

    @Override
    public synchronized Map<String, String> getHolidays(Locale locale, int year) {
        Map<String, String> map;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((map = this.days.get(locale + "_" + year)) == null) {
            File f = null;
            f = MApi.getFile("holidays_" + locale.toString() + "_" + year + ".txt");
            if (f == null || !f.exists()) {
                f = MApi.getFile("holidays_" + year + ".txt");
            }
            if (f != null && f.exists()) {
                try {
                    map = new HashMap<String, String>();
                    for (String line : MFile.readLines(f, true)) {
                        Date d;
                        if (!MString.isSet(line = line.trim()) || line.startsWith("#")) continue;
                        String date = null;
                        String msg = "";
                        if (MString.isIndex(line, ' ')) {
                            date = MString.beforeIndex(line, ' ').trim();
                            msg = MString.afterIndex(line, ' ').trim();
                        } else {
                            date = line;
                        }
                        if ((d = MDate.toDate(date, null)) == null) continue;
                        d = MDate.toDateOnly(d);
                        map.put(d.getDate() + "." + (d.getMonth() + 1), msg);
                    }
                    this.days.put(locale + "_" + year, map);
                }
                catch (Exception e) {
                    this.log().d(e);
                }
            } else {
                this.log().d("Definition file not found", locale, year);
                map = new HashMap<String, String>();
                this.fillDefaultHolydays(locale, map);
                this.days.put(locale + "_" + year, map);
            }
        }
        return map;
    }

    protected void fillDefaultHolydays(Locale locale, Map<String, String> map) {
        map.put("1.1", "New Year");
        map.put("1.5", "1. May");
        map.put("25.12", "X-Mas");
        map.put("26.12", "X-Mas");
    }
}

