/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.activator;

import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.activator.MutableActivator;
import de.mhus.lib.core.config.IFlatConfig;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.errors.MException;
import java.io.Closeable;
import java.util.HashMap;

public class DefaultActivator
extends MActivator
implements MutableActivator {
    protected HashMap<String, Object> mapper;
    protected HashMap<String, Object> instances;

    public DefaultActivator() {
        this.mapper = new HashMap();
        this.instances = new HashMap();
    }

    public DefaultActivator(ClassLoader loader) {
        super(loader);
        this.mapper = new HashMap();
        this.instances = new HashMap();
    }

    public DefaultActivator(ResourceNode<?> cactivator, ClassLoader loader) throws MException {
        block4: {
            super(loader);
            this.mapper = new HashMap();
            this.instances = new HashMap();
            if (cactivator == null) break block4;
            if (cactivator instanceof IFlatConfig) {
                for (String key : cactivator.getPropertyKeys()) {
                    this.addMap(key, cactivator.getExtracted(key));
                }
            } else {
                for (ResourceNode entry : cactivator.getNodes("map")) {
                    this.addMap(entry.getExtracted("name", ""), entry.getExtracted("class", ""));
                }
            }
        }
    }

    @Override
    public void addObject(Class<?> ifc, String name, Object obj) {
        if (ifc == null) {
            this.setInstance(name, obj);
        } else {
            this.setInstance(ifc.getCanonicalName() + (name != null ? ":" + name : ""), obj);
        }
    }

    @Override
    public void setInstance(String name, Object obj) {
        this.instances.put(name, obj);
    }

    public void addMap(String name, String clazz) {
        if (name == null || clazz == null) {
            return;
        }
        this.mapper.put(name, clazz);
    }

    @Override
    public void addMap(Class<?> ifc, String name, Class<?> clazz) {
        this.addMap(ifc.getCanonicalName() + ":" + name, clazz);
    }

    @Override
    public void addMap(String name, Class<?> clazz) {
        if (name == null || clazz == null) {
            return;
        }
        this.mapper.put(name, clazz);
    }

    @Override
    public Object mapName(String name) {
        if (name == null) {
            return name;
        }
        if (this.mapper.containsKey(name)) {
            return this.mapper.get(name);
        }
        return name;
    }

    @Override
    public boolean isInstance(String ifc) {
        return this.instances.containsKey(ifc);
    }

    @Override
    public void destroy() {
        super.destroy();
        for (Object obj : this.instances.values()) {
            if (!(obj instanceof Closeable)) continue;
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable throwable) {}
        }
        this.mapper = null;
    }

    @Override
    protected Object getInstance(String name) {
        return this.instances.get(name);
    }

    @Override
    public void addMap(Class<?> ifc, Class<?> clazz) {
        this.addMap(ifc.getCanonicalName(), clazz);
    }

    @Override
    public void removeMap(String name) {
        this.mapper.remove(name);
    }

    @Override
    public void removeObject(String name) {
        this.removeObject(null, name);
    }

    @Override
    public void removeObject(Class<?> ifc, String name) {
        if (ifc == null) {
            this.instances.remove(name);
        } else {
            this.instances.remove(ifc.getCanonicalName() + (name != null ? ":" + name : ""));
        }
    }

    @Override
    public String[] getMapNames() {
        return this.mapper.keySet().toArray(new String[this.mapper.size()]);
    }

    @Override
    public String[] getObjectNames() {
        return this.instances.keySet().toArray(new String[this.mapper.size()]);
    }
}

