/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.ITimerTask;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.logging.MLogUtil;
import java.lang.reflect.Field;
import java.util.TimerTask;

public abstract class MTimerTask
extends TimerTask
implements ITimerTask {
    public static final int UNKNOWN = -1;
    public static final int VIRGIN = 0;
    public static final int SCHEDULED = 1;
    public static final int EXECUTED = 2;
    public static final int CANCELLED = 3;
    private boolean canceled = false;
    private String name;
    protected Object environment;

    public MTimerTask() {
        this.setName(MSystem.getClassName(this));
    }

    @Override
    public final void run() {
        this.run(null);
    }

    @Override
    public final void run(Object environment) {
        boolean error = false;
        try {
            this.environment = environment;
            this.doit();
        }
        catch (Throwable t) {
            try {
                this.onError(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            error = true;
        }
        try {
            this.onFinal(error);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.environment = null;
    }

    @Override
    public void onError(Throwable t) {
        t.printStackTrace();
    }

    @Override
    public void onFinal(boolean isError) {
    }

    protected abstract void doit() throws Exception;

    @Override
    public boolean cancel() {
        this.setCanceled(true);
        return super.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static int getStatus(TimerTask task) {
        if (task == null) {
            return -1;
        }
        try {
            Class<?> clazz = task.getClass();
            Field field = MSystem.getDeclaredField(clazz, "state");
            if (field != null) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.getInt(task);
            }
        }
        catch (Throwable t) {
            MLogUtil.log().d(task, t);
        }
        return -1;
    }
}

