/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging.adapters;

import de.mhus.lib.core.logging.Log;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class Log4JAppender
extends AppenderSkeleton {
    protected void append(LoggingEvent evt) {
        Level level = evt.getLevel();
        LocationInfo location = evt.getLocationInformation();
        String loggerName = evt.getLoggerName();
        Object msg = evt.getMessage();
        ThrowableInformation throwableInfo = evt.getThrowableInformation();
        Throwable t = null;
        if (throwableInfo != null) {
            t = throwableInfo.getThrowable();
        }
        Log logger = Log.getLog(loggerName);
        String method = location.getClassName() + "." + location.getMethodName() + ":" + location.getLineNumber();
        switch (level.toInt()) {
            case 50000: {
                logger.f(method, msg, t);
                break;
            }
            case 40000: {
                logger.e(method, msg, t);
                break;
            }
            case 30000: {
                logger.w(method, msg, t);
                break;
            }
            case 20000: {
                logger.i(method, msg, t);
                break;
            }
            case 10000: {
                logger.d(method, msg, t);
                break;
            }
            case 5000: {
                logger.t(method, msg, t);
                break;
            }
            default: {
                logger.t(method, msg, t);
            }
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public static void configure() {
        Log4JAppender appender = new Log4JAppender();
        appender.setThreshold((Priority)Level.ALL);
        appender.setName("mlog2log4j");
        appender.activateOptions();
        Logger.getRootLogger().addAppender((Appender)appender);
    }
}

