/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.pojo.MPojo;
import de.mhus.lib.core.pojo.PojoModel;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.PojoProvider;
import de.mhus.lib.form.UiComponent;
import java.io.IOException;

public class PojoDataSource
extends MLog
implements DataSource {
    private PojoProvider pojo;
    private PojoModel model;

    public PojoDataSource(PojoProvider pojo) {
        this.pojo = pojo;
        this.model = MPojo.getDefaultModelFactory().createPojoModel(pojo.getPojo().getClass());
    }

    @Override
    public boolean getBoolean(UiComponent component, String name, boolean def) {
        try {
            this.log().t("getBoolean", component, name, def);
            return (Boolean)this.model.getAttribute(this.getName(component, name)).get(this.pojo.getPojo());
        }
        catch (Throwable e) {
            this.log().t(e);
            return def;
        }
    }

    protected String getName(UiComponent component, String name) {
        String ret = (component.getName() + name).toLowerCase();
        return ret;
    }

    @Override
    public int getInt(UiComponent component, String name, int def) {
        try {
            this.log().t("getInt", component, name, def);
            return (Integer)this.model.getAttribute(this.getName(component, name)).get(this.pojo.getPojo());
        }
        catch (Throwable e) {
            this.log().t(e);
            return def;
        }
    }

    @Override
    public String getString(UiComponent component, String name, String def) {
        try {
            this.log().t("getString", component, name, def);
            String ret = (String)this.model.getAttribute(this.getName(component, name)).get(this.pojo.getPojo());
            if (ret == null) {
                return def;
            }
            return ret;
        }
        catch (Throwable e) {
            this.log().t(e);
            return def;
        }
    }

    @Override
    public Object getObject(UiComponent component, String name, Object def) {
        try {
            this.log().t("getObject", component, name, def);
            Object ret = this.model.getAttribute(this.getName(component, name)).get(this.pojo.getPojo());
            if (ret == null) {
                return def;
            }
            return ret;
        }
        catch (Throwable e) {
            this.log().t(e);
            return def;
        }
    }

    @Override
    public void setObject(UiComponent component, String name, Object value) throws IOException {
        this.log().t("setObject", component, name, value);
        this.model.getAttribute(this.getName(component, name)).set(this.pojo.getPojo(), value);
    }

    @Override
    public DataSource getNext() {
        return null;
    }
}

